/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.docbook2wordml;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPhrase;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.AnchorWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.LinkWriter;
import com.arcway.cockpit.docgen.writer.wordML.dom.IPhraseParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.PhraseWrapper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.List;

public class PhraseWriter {
    private static ILogger logger = Logger.getLogger(PhraseWriter.class);
    private static PhraseWriter writer;

    public static PhraseWriter getInstance() {
        if (writer == null) {
            writer = new PhraseWriter();
        }
        return writer;
    }

    private PhraseWriter() {
    }

    public void write(EOPhrase para, IPhraseParent parent, DocBook2WordMLGenerationContext context) {
        List contentList = para.getContent(context.getReportJob());
        PhraseWrapper wrapper = parent.addPhrase();
        for (Object obj : contentList) {
            if (obj instanceof String) {
                wrapper.addPhraseText((String)obj);
                if (!logger.isDebugEnabled(180)) continue;
                logger.debug(180, "[write paragraph] inserted text " + (String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, parent, context);
                continue;
            }
            if (!(obj instanceof EOLink)) continue;
            LinkWriter.getInstance().write((EOLink)obj, parent, context);
        }
    }
}

