/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractIntegerValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class IntegerListFilterItem
extends AbstractFilterItem {
    private static final String FILTER_INFO_SEPARATOR = ", ";
    private String name = null;
    private final List<String> texts = new ArrayList<String>();
    private final List<Integer> integerValues = new ArrayList<Integer>();
    private AbstractIntegerValuesFilter filter = null;
    private final List<Button> tableItems = new ArrayList<Button>();
    private HashSet<Integer> values;

    public IntegerListFilterItem(String name, AbstractIntegerValuesFilter filter) {
        super(name, filter);
        this.name = name;
        this.filter = filter;
        this.values = new HashSet<Integer>(filter.getPassValues());
    }

    public void addFilterValue(String text, Integer value) {
        this.texts.add(text);
        this.integerValues.add(value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        StringBuilder filterInfo = new StringBuilder();
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            if (filterInfo.length() > 0) {
                filterInfo.append(FILTER_INFO_SEPARATOR);
            }
            filterInfo.append(button.getText());
        }
        return filterInfo.toString();
    }

    @Override
    public Control createContent(Composite parent) {
        Group composite = new Group(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.verticalSpacing = 2;
        compositeLayout.horizontalSpacing = 2;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeGD = new GridData(1808);
        composite.setLayoutData((Object)compositeGD);
        composite.setText(this.getName());
        int i = 0;
        while (i < this.texts.size()) {
            Button button = new Button((Composite)composite, 32);
            String text = this.texts.get(i);
            Integer value = this.integerValues.get(i);
            button.setText(text);
            button.setData((Object)value);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IntegerListFilterItem.this.fireValueChanged();
                    IntegerListFilterItem.this.updateFilter();
                }
            });
            this.updateValueCheckState(button);
            this.tableItems.add(button);
            ++i;
        }
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IntegerListFilterItem.this.tableItems.clear();
            }
        });
        return composite;
    }

    @Override
    public void refresh() {
        for (Button button : this.tableItems) {
            this.updateValueCheckState(button);
        }
    }

    @Override
    public boolean isNoFilterValuesSet() {
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllFilterValuesSet() {
        for (Button button : this.tableItems) {
            if (button.getSelection()) continue;
            return false;
        }
        return true;
    }

    private void updateFilter() {
        boolean activateFilter = false;
        this.values.clear();
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            Integer value = (Integer)button.getData();
            this.values.add(value);
            activateFilter |= true;
        }
        this.setSelected(activateFilter);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setPassValues(this.values);
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.values = new HashSet<Integer>(this.filter.getPassValues());
    }

    private void updateValueCheckState(Button button) {
        Integer value = (Integer)button.getData();
        if (this.values.contains(value)) {
            button.setSelection(true);
        }
    }

    @Override
    public void filterHasChanged() {
        this.values = new HashSet<Integer>(this.filter.getPassValues());
    }
}

