/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractDiscreteValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import de.plans.lib.util.valueranges.DiscreteValue;
import de.plans.lib.util.valueranges.IValueRangeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DiscreteValueListFilterItem
extends AbstractFilterItem {
    private static final String FILTER_INFO_SEPARATOR = ", ";
    private String name = null;
    private final List<String> texts = new ArrayList<String>();
    private final List<DiscreteValue> discreteValues = new ArrayList<DiscreteValue>();
    private AbstractDiscreteValueFilter filter = null;
    private final List<Button> tableItems = new ArrayList<Button>();
    private List<Integer> passValues;

    public DiscreteValueListFilterItem(String name, List<? extends DiscreteValue> possibleValues, AbstractDiscreteValueFilter filter) {
        super(name, filter);
        this.name = name;
        this.filter = filter;
        for (DiscreteValue discreteValue : possibleValues) {
            String displayRepresentation = discreteValue.getName(Locale.getDefault());
            if (displayRepresentation.equals("")) {
                displayRepresentation = IValueRangeHelper.NOT_SPECIFIED;
            }
            this.addFilterValue(displayRepresentation, discreteValue);
        }
        this.passValues = new ArrayList<Integer>(filter.getPassValues());
    }

    public void addFilterValue(String text, DiscreteValue value) {
        this.texts.add(text);
        this.discreteValues.add(value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        StringBuffer filterInfo = new StringBuffer();
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            if (filterInfo.length() > 0) {
                filterInfo.append(FILTER_INFO_SEPARATOR);
            }
            filterInfo.append(button.getText());
        }
        return filterInfo.toString();
    }

    @Override
    public Control createContent(Composite parent) {
        this.tableItems.clear();
        Group composite = new Group(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.verticalSpacing = 2;
        compositeLayout.horizontalSpacing = 2;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeGD = new GridData(1808);
        composite.setLayoutData((Object)compositeGD);
        composite.setText(this.getName());
        int i = 0;
        while (i < this.texts.size()) {
            Button button = new Button((Composite)composite, 32);
            String text = this.texts.get(i);
            DiscreteValue value = this.discreteValues.get(i);
            button.setText(text);
            button.setData((Object)value);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DiscreteValueListFilterItem.this.updateFilter();
                    DiscreteValueListFilterItem.this.fireValueChanged();
                }
            });
            this.updateValueCheckState(button);
            this.tableItems.add(button);
            ++i;
        }
        return composite;
    }

    @Override
    public void refresh() {
        for (Button button : this.tableItems) {
            this.updateValueCheckState(button);
        }
    }

    @Override
    public boolean isNoFilterValuesSet() {
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllFilterValuesSet() {
        for (Button button : this.tableItems) {
            if (button.getSelection()) continue;
            return false;
        }
        return true;
    }

    private void updateFilter() {
        boolean activateFilter = false;
        this.passValues.clear();
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            DiscreteValue value = (DiscreteValue)button.getData();
            Integer index = this.discreteValues.indexOf(value);
            this.passValues.add(index);
            activateFilter = true;
        }
        this.setSelected(activateFilter);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setPassValues(this.passValues);
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.passValues = this.filter.getPassValues();
    }

    private void updateValueCheckState(Button button) {
        List<Integer> passValues_ = this.passValues;
        DiscreteValue value = (DiscreteValue)button.getData();
        int valueIndex = this.discreteValues.indexOf(value);
        if (passValues_.contains(valueIndex)) {
            button.setSelection(true);
        }
    }

    @Override
    public void filterHasChanged() {
        this.passValues = this.filter.getPassValues();
    }
}

