/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.client.base.datamanager;

import com.arcway.cockpit.client.base.datamanager.AccessAgentModificationAccess;
import com.arcway.cockpit.client.base.datamanager.IDataHandler;
import com.arcway.cockpit.frame.shared.message.EOGenericCockpitDatabaseData;
import com.arcway.lib.java.tuples.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DataModificationLogMgr<T, T_UID, T_EO extends EOGenericCockpitDatabaseData> {
    private final IDataHandler<T, T_UID, ?, T_EO> dataHandler;
    private final AccessAgentModificationAccess<T, T_UID, T_EO> accessAgentModificationAccess;
    private final Map<T_UID, T> addedDataItems = new HashMap<T_UID, T>();
    private final Map<T_UID, T> updatedDataItems = new HashMap<T_UID, T>();
    private final Map<T_UID, T> removedDataItems = new HashMap<T_UID, T>();

    public DataModificationLogMgr(IDataHandler<T, T_UID, ?, T_EO> dataHandler, AccessAgentModificationAccess<T, T_UID, T_EO> accessAgentModificationAccess) {
        this.dataHandler = dataHandler;
        this.accessAgentModificationAccess = accessAgentModificationAccess;
        this.accessAgentModificationAccess.setDataModificationLogMgr(this);
    }

    public AccessAgentModificationAccess<T, T_UID, T_EO> getAccessAgentModificationAccess() {
        return this.accessAgentModificationAccess;
    }

    protected void clear() {
        this.clearAddedItems();
        this.clearUpdatedItems();
        this.clearRemovedItems();
    }

    protected boolean hasModifications() {
        return !this.addedDataItems.isEmpty() || !this.updatedDataItems.isEmpty() || !this.removedDataItems.isEmpty();
    }

    protected void clearAddedItems() {
        this.accessAgentModificationAccess.discardAllModificationsOfModType('a');
        this.addedDataItems.clear();
    }

    protected T getAddedItem(T_UID itemUID) {
        assert (itemUID != null) : "data UID is null";
        return this.addedDataItems.get(itemUID);
    }

    protected void addAddedItem(T item) {
        assert (item != null) : "item is null";
        T previousValue = this.addedDataItems.put(this.dataHandler.getUIDForItem(item), item);
        this.accessAgentModificationAccess.addItemOfModType(item, 'a', this.dataHandler, previousValue != null);
    }

    protected T removeAddedItem(T_UID itemUID) {
        assert (itemUID != null) : "itemUID is null";
        T previousValue = this.addedDataItems.remove(itemUID);
        if (previousValue != null) {
            this.accessAgentModificationAccess.removeItemOfModType(itemUID, 'a', this.dataHandler);
        }
        return previousValue;
    }

    protected boolean containsAddedItem(T_UID itemUID) {
        assert (itemUID != null) : "itemUID is null";
        return this.addedDataItems.containsKey(itemUID);
    }

    protected List<T> getAllAddedItems() {
        ArrayList<T> items = new ArrayList<T>(this.addedDataItems.size());
        items.addAll(this.addedDataItems.values());
        return items;
    }

    protected void clearUpdatedItems() {
        this.accessAgentModificationAccess.discardAllModificationsOfModType('u');
        this.updatedDataItems.clear();
    }

    protected T getUpdatedItem(T_UID itemUID) {
        assert (itemUID != null) : "data UID is null";
        return this.updatedDataItems.get(itemUID);
    }

    protected void addUpdatedItem(T item) {
        assert (item != null) : "item is null";
        T previousValue = this.updatedDataItems.put(this.dataHandler.getUIDForItem(item), item);
        this.accessAgentModificationAccess.addItemOfModType(item, 'u', this.dataHandler, previousValue != null);
    }

    protected T removeUpdatedItem(T_UID itemUID) {
        assert (itemUID != null) : "itemUID is null";
        T previousValue = this.updatedDataItems.remove(itemUID);
        if (previousValue != null) {
            this.accessAgentModificationAccess.removeItemOfModType(itemUID, 'u', this.dataHandler);
        }
        return previousValue;
    }

    protected boolean containsUpdatedItem(T_UID itemUID) {
        assert (itemUID != null) : "itemUID is null";
        return this.updatedDataItems.containsKey(itemUID);
    }

    protected List<T> getAllUpdatedItems() {
        ArrayList<T> items = new ArrayList<T>(this.updatedDataItems.size());
        items.addAll(this.updatedDataItems.values());
        return items;
    }

    protected void clearRemovedItems() {
        this.accessAgentModificationAccess.discardAllModificationsOfModType('r');
        this.removedDataItems.clear();
    }

    protected T getRemovedItem(T_UID itemUID) {
        assert (itemUID != null) : "data UID is null";
        return this.removedDataItems.get(itemUID);
    }

    protected void addRemovedItem(T item) {
        assert (item != null) : "item is null";
        T previousValue = this.removedDataItems.put(this.dataHandler.getUIDForItem(item), item);
        this.accessAgentModificationAccess.addItemOfModType(item, 'r', this.dataHandler, previousValue != null);
    }

    protected T removeRemovedItem(T_UID itemUID) {
        assert (itemUID != null) : "itemUID is null";
        T previousValue = this.removedDataItems.remove(itemUID);
        if (previousValue != null) {
            this.accessAgentModificationAccess.removeItemOfModType(itemUID, 'r', this.dataHandler);
        }
        return previousValue;
    }

    protected boolean containsRemovedItem(T_UID itemUID) {
        assert (itemUID != null) : "itemUID is null";
        return this.removedDataItems.containsKey(itemUID);
    }

    protected List<T> getAllRemovedItems() {
        ArrayList<T> items = new ArrayList<T>(this.removedDataItems.size());
        items.addAll(this.removedDataItems.values());
        return items;
    }

    public void reconstructDiskStateFromInMemoryState() {
        this.accessAgentModificationAccess.discardAllModificationsOfModType('a');
        for (T item : this.addedDataItems.values()) {
            this.accessAgentModificationAccess.addItemOfModType(item, 'a', this.dataHandler, false);
        }
        this.accessAgentModificationAccess.discardAllModificationsOfModType('u');
        for (T item : this.updatedDataItems.values()) {
            this.accessAgentModificationAccess.addItemOfModType(item, 'u', this.dataHandler, false);
        }
        this.accessAgentModificationAccess.discardAllModificationsOfModType('r');
        for (T item : this.removedDataItems.values()) {
            this.accessAgentModificationAccess.addItemOfModType(item, 'r', this.dataHandler, false);
        }
    }

    public void checkModificationIntegrity() throws Exception {
        ArrayList<Tuple> checklist = new ArrayList<Tuple>(3);
        checklist.add(new Tuple((Object)Character.valueOf('a'), this.addedDataItems));
        checklist.add(new Tuple((Object)Character.valueOf('u'), this.updatedDataItems));
        checklist.add(new Tuple((Object)Character.valueOf('r'), this.removedDataItems));
        for (Tuple tuple : checklist) {
            Character modType = (Character)tuple.getT1();
            Map dataItems = (Map)tuple.getT2();
            List<T> allItemsOfModType = this.accessAgentModificationAccess.getAllItemsOfModType(modType.charValue(), this.dataHandler);
            assert (allItemsOfModType.size() == dataItems.size());
            HashSet<String> keys = new HashSet<String>(dataItems.size() * 2);
            for (Object uid : dataItems.keySet()) {
                boolean notADuplicate = keys.add(this.dataHandler.getUIDStringForUID(uid));
                assert (notADuplicate);
            }
            for (Object item : allItemsOfModType) {
                boolean wasContained = keys.remove(this.dataHandler.getUIDStringForItem(item));
                assert (wasContained);
            }
            assert (keys.isEmpty());
        }
    }
}

