/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions.actions;

import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollectionRW_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.repository.implementation.transactions.AbstractElementaryAction;
import com.arcway.repository.implementation.transactions.actions.LockHelper;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.RepositoryRelations;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.transactions.exceptions.EXOccurrenceObjectIDsDiffer;
import com.arcway.repository.interFace.transactions.exceptions.EXOccurrenceRelationTypeIDsDiffer;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.OccurrenceRelationContribution;
import com.arcway.repository.lib.high.implementation.access.OccurrenceRepositoryRelationReference;
import java.util.ArrayList;
import java.util.Arrays;

public class REAModifyOccurrences
extends AbstractElementaryAction {
    private final OccurrenceRelationContribution occRelationContribution;
    private final ICollection_<IOccurrenceRepositoryRelationReference> occurrenceRelationsToDelete;
    private final ICollection_<IOccurrenceRepositoryRelationSample> occurrenceRelationsToCreate;
    private final ICollectionRW_<IOccurrenceRepositoryRelationSample> deletedRelations = new ArrayList_();

    public REAModifyOccurrences(OccurrenceRelationContribution occRelationContribution, ICollection_<IOccurrenceRepositoryRelationReference> occurrenceRelationsToDelete, ICollection_<IOccurrenceRepositoryRelationSample> occurrenceRelationsToCreate) {
        this.occRelationContribution = occRelationContribution;
        this.occurrenceRelationsToDelete = occurrenceRelationsToDelete;
        this.occurrenceRelationsToCreate = occurrenceRelationsToCreate;
    }

    @Override
    public void execute(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        Object objectIDofOccurrenceContainingObject;
        IRepositoryRelationTypeID occurringRCTypeRelationTypeID = this.occRelationContribution.getOccurrenceRCType().getRelatedPropertyType().getOccuringRelationContributionType().getRelatedRelationType().getRepositoryRelationTypeID();
        IRepositoryPropertySetSample propertyRelatedObjectID = this.occRelationContribution.getOccurrenceContainingObjectObjectID();
        for (IOccurrenceRepositoryRelationReference occurrenceRelationToDelete : this.occurrenceRelationsToDelete) {
            objectIDofOccurrenceContainingObject = occurrenceRelationToDelete.getObjectIDofOccurrenceContainingObject();
            this.doChecks(occurrenceRelationToDelete.getRelationTypeID(), occurringRCTypeRelationTypeID, (IRepositoryPropertySetSample)objectIDofOccurrenceContainingObject, propertyRelatedObjectID);
        }
        for (IOccurrenceRepositoryRelationSample occurrenceRelationToCreate : this.occurrenceRelationsToCreate) {
            objectIDofOccurrenceContainingObject = occurrenceRelationToCreate.getObjectIDofOccurrenceContainingObject();
            this.doChecks(occurrenceRelationToCreate.getRelationTypeID(), occurringRCTypeRelationTypeID, (IRepositoryPropertySetSample)objectIDofOccurrenceContainingObject, propertyRelatedObjectID);
        }
        ArrayList_ deletedRelationsToLock = new ArrayList_();
        for (IOccurrenceRepositoryRelationReference occurrenceRelationToDelete : this.occurrenceRelationsToDelete) {
            IOccurrenceRepositoryRelation deletedRelation = RepositoryReferences.getFromReference((IOccurrenceRepositoryRelationReference)occurrenceRelationToDelete, (IRepositorySnapshotRO)snapshot);
            deletedRelationsToLock.add((Object)deletedRelation);
            this.deletedRelations.add((Object)deletedRelation.sample());
        }
        snapshot.modifyOccurrences(this.occRelationContribution, this.occurrenceRelationsToDelete, this.occurrenceRelationsToCreate);
        try {
            ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
            for (IOccurrenceRepositoryRelation deletedRelationToLock : deletedRelationsToLock) {
                locks.addAll(Arrays.asList(LockHelper.lockOccurrenceRelation(deletedRelationToLock)));
            }
            for (IOccurrenceRepositoryRelationSample occurrenceRelationToCreate : this.occurrenceRelationsToCreate) {
                locks.addAll(Arrays.asList(LockHelper.lockOccurrenceRelation(RepositoryRelations.findOccurrenceRelation((IOccurrenceRepositoryRelationSample)occurrenceRelationToCreate, (IRepositorySnapshotRO)snapshot))));
            }
            this.setLocks(locks.toArray(new AbstractRepositoryLockSample[locks.size()]));
        }
        catch (EXNotReproducibleSnapshot e) {
            this.rollback(snapshot);
            throw e;
        }
    }

    private void doChecks(IRepositoryRelationTypeID occurrenceRelationRelationTypeID, IRepositoryRelationTypeID occurringRCTypeRelationTypeID, IRepositoryPropertySetSample objectIDofOccurrenceContainingObject, IRepositoryPropertySetSample propertyRelatedObjectID) throws EXTransactionExecution {
        if (!IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER.isEqual((Object)occurrenceRelationRelationTypeID, (Object)occurringRCTypeRelationTypeID)) {
            IRepositoryObjectTypeID objectTypeID = this.occRelationContribution.getOccurrenceRCType().getRelatedPropertyType().getAttributeSetType().getObjectType().getRepositoryObjectTypeID();
            IRepositoryPropertyTypeID propertyTypeID = this.occRelationContribution.getOccurrenceRCType().getRelatedPropertyType().getRepositoryPropertyTypeID();
            throw new EXOccurrenceRelationTypeIDsDiffer(occurrenceRelationRelationTypeID, occurringRCTypeRelationTypeID, propertyTypeID, objectTypeID, objectIDofOccurrenceContainingObject, propertyRelatedObjectID);
        }
        if (!IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)objectIDofOccurrenceContainingObject, (Object)propertyRelatedObjectID)) {
            IRepositoryObjectTypeID objectTypeID = this.occRelationContribution.getOccurrenceRCType().getRelatedPropertyType().getAttributeSetType().getObjectType().getRepositoryObjectTypeID();
            IRepositoryPropertyTypeID propertyTypeID = this.occRelationContribution.getOccurrenceRCType().getRelatedPropertyType().getRepositoryPropertyTypeID();
            throw new EXOccurrenceObjectIDsDiffer(objectIDofOccurrenceContainingObject, propertyRelatedObjectID, propertyTypeID, objectTypeID);
        }
    }

    @Override
    public void rollback(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        ArrayList_ createdRelations = new ArrayList_();
        for (IOccurrenceRepositoryRelationSample occurrenceRelationToCreate : this.occurrenceRelationsToCreate) {
            IOccurrenceRepositoryRelation occurrenceRelation = RepositoryRelations.findOccurrenceRelation((IOccurrenceRepositoryRelationSample)occurrenceRelationToCreate, (IRepositorySnapshotRO)snapshot);
            assert (occurrenceRelation != null);
            createdRelations.add((Object)new OccurrenceRepositoryRelationReference(occurrenceRelation));
        }
        snapshot.modifyOccurrences(this.occRelationContribution, (ICollection_)createdRelations, this.deletedRelations);
    }

    public String getName() {
        return "Modify Occurrence Action";
    }
}

