/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions;

import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.transactions.AbstractRepositoryAction;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionContext;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;

public abstract class AbstractElementaryAction
extends AbstractRepositoryAction {
    private AbstractRepositoryLockSample[] locks = null;
    private boolean isExecuted = false;

    public abstract void execute(IRepositorySnapshotRW var1) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied;

    public final void execute(IRepositoryTransactionContext transaction) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        Assert.checkState((!this.isExecuted ? 1 : 0) != 0);
        Assert.checkObjectArgumentToBeInstanceOf((Object)transaction.getSnapshot(), IRepositorySnapshotRW.class);
        IRepositorySnapshotRW snapshotRW = (IRepositorySnapshotRW)transaction.getSnapshot();
        this.execute(snapshotRW);
        assert (this.locks != null);
        this.isExecuted = true;
    }

    public abstract void rollback(IRepositorySnapshotRW var1) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution;

    public final void rollback(IRepositoryTransactionContext transaction) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        Assert.checkState((boolean)this.isExecuted);
        Assert.checkObjectArgumentToBeInstanceOf((Object)transaction.getSnapshot(), IRepositorySnapshotRW.class);
        IRepositorySnapshotRW snapshotRW = (IRepositorySnapshotRW)transaction.getSnapshot();
        this.rollback(snapshotRW);
        this.isExecuted = false;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractElementaryAction clone = (AbstractElementaryAction)((Object)super.clone());
        clone.locks = null;
        clone.isExecuted = false;
        return clone;
    }

    public AbstractRepositoryLockSample[] getLocks() {
        assert (this.locks != null);
        return (AbstractRepositoryLockSample[])this.locks.clone();
    }

    protected void setLocks(AbstractRepositoryLockSample[] l) {
        Assert.checkArgumentBeeingNotNull((Object)l);
        this.locks = l;
    }

    public boolean isExecuted() {
        return this.isExecuted;
    }

    public boolean isRolledBack() {
        return !this.isExecuted;
    }
}

