/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.bpmn.bpd.view;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planview.bpmn.bpd.view.PVGraphicalSupplementEventTypeSymbol;

public class PVGraphicalSupplementEventTimeSymbol
extends PVGraphicalSupplementEventTypeSymbol {
    public void drawFigure(Device device) {
        assert (this.symbolAppearance != null) : "symbolAppearance is NULL";
        IFillAppearanceRO fillAppearance = this.symbolAppearance.getFillAppearanceRO();
        assert (fillAppearance != null) : "fillAppearance is null.";
        ILineAppearanceRO lineAppearance = this.symbolAppearance.getLineAppearanceRO();
        assert (lineAppearance != null) : "lineAppearance is null.";
        FillStyle fillStyle = fillAppearance.getFillStyle();
        FillColor fillColor = fillAppearance.getFillColor();
        Color lineColor = lineAppearance.getLineColor();
        double thickness = lineAppearance.getLineThickness();
        Rectangle bounds = this.getPoints().getBounds();
        assert (bounds != null) : "bounds is NULL.";
        Point center = bounds.center();
        double width = bounds.w() * 0.65;
        double height = bounds.h() * 0.65;
        thickness *= (width + height) * 0.5 * 0.2;
        double leftBound = center.x - width / 2.0;
        double upperBound = center.y - height / 2.0;
        Corners corners = new Corners();
        corners.add((Point)new Corner(leftBound, upperBound));
        corners.add((Point)new Corner(leftBound, upperBound + height));
        corners.add((Point)new Corner(leftBound + width, upperBound + height));
        corners.add((Point)new Corner(leftBound + width, upperBound));
        device.polygon(corners, fillColor, fillStyle, thickness, lineColor, LineStyle.SOLID);
        Corners standardHourTick = new Corners();
        standardHourTick.add((Point)new Corner(leftBound + width / 2.0, upperBound));
        standardHourTick.add((Point)new Corner(leftBound + width / 2.0, upperBound + height * 0.1));
        double anglePerTooth = 30.0;
        int i = 0;
        while (i < 12) {
            corners = standardHourTick.turnCorners(center, (double)i * anglePerTooth);
            device.polyline(corners, thickness, lineColor, LineStyle.SOLID);
            ++i;
        }
        corners = new Corners();
        corners.add((Point)new Corner(center, 0.0));
        corners.add((Point)new Corner(center.x, center.y - height * 0.45));
        corners = corners.turnCorners(center, -8.0);
        device.polyline(corners, thickness, lineColor, LineStyle.SOLID);
        corners = new Corners();
        corners.add((Point)new Corner(center, 0.0));
        corners.add((Point)new Corner(center.x + width / 3.0, center.y));
        device.polyline(corners, thickness, lineColor, LineStyle.SOLID);
    }
}

