/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.Collection;
import java.util.Collections;

public class TAMovePoint
extends Transaction {
    private final GeoVector distance;

    public TAMovePoint(IPMPointRO point, ActionParameters actionParameters, GeoVector distance) {
        super((IPMPlanModelObjectRW)((Object)point), actionParameters);
        assert (distance != null) : "distance object is null";
        this.distance = distance;
    }

    @Override
    public ActionIterator getActionIterator() {
        IPMPointRW pointToMove = (IPMPointRW)this.getTransactionRoot();
        PredeterminedActionIterator moveActionIterator = new PredeterminedActionIterator();
        ACMovePoint movePointAction = ActionFactory.createACMovePoint(this.getActionContext(), pointToMove, this.distance, true);
        moveActionIterator.addAction(movePointAction);
        return moveActionIterator;
    }

    @Override
    protected Collection<? extends IPMPlanModelObjectRW> getPrimarilyChangedPlanModelObjects() {
        IPMPointRW pointToMove = (IPMPointRW)this.getTransactionRoot();
        return Collections.singleton(pointToMove.getPointListRW());
    }

    public String toString() {
        return "TAMovePoint ()";
    }
}

