/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACCreate1Point;
import com.arcway.planagent.planmodel.actions.ACSetLineForce;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TAInsert2Points
extends PredeterminedLengthTransaction {
    private static final int STEPS = 4;
    private final Point newPosition;
    private final IPMPointRW fixPoint;
    private final IPMLineRW lineToSplit;

    public TAInsert2Points(IPMLineRO lineToSplit, ActionParameters actionParameters, IPMPointRO fixPoint, Point newPosition) {
        super(4, (IPMPlanModelObjectRW)((Object)lineToSplit), actionParameters);
        assert (newPosition != null);
        assert (fixPoint != null);
        assert (fixPoint == lineToSplit.getPoint1stRO() || fixPoint == lineToSplit.getPoint2ndRO());
        this.newPosition = newPosition;
        this.fixPoint = (IPMPointRW)((Object)fixPoint);
        this.lineToSplit = (IPMLineRW)((Object)lineToSplit);
    }

    @Override
    public Action createAction(int n, ArrayList<Action> previousActions) {
        Action nextAction = null;
        switch (n) {
            case 0: {
                nextAction = new ACCreate1Point(this.getActionContext(), this.fixPoint, this.lineToSplit);
                break;
            }
            case 1: {
                ACCreate1Point createFirstPointAction = (ACCreate1Point)previousActions.get(0);
                nextAction = new ACCreate1Point(this.getActionContext(), createFirstPointAction.getCreatedPoint(), this.lineToSplit);
                break;
            }
            case 2: {
                ACCreate1Point createSecondPointAction = (ACCreate1Point)previousActions.get(1);
                int lineForce = 1;
                switch (this.lineToSplit.getForce()) {
                    case 2: {
                        lineForce = 3;
                        break;
                    }
                    case 3: {
                        lineForce = 2;
                    }
                }
                nextAction = new ACSetLineForce(this.getActionContext(), createSecondPointAction.getCreatedLine(), lineForce);
                break;
            }
            case 3: {
                ACCreate1Point createSecondPointAction = (ACCreate1Point)previousActions.get(1);
                IPMPointRW createdPoint = createSecondPointAction.getCreatedPoint();
                GeoVector distance = new GeoVector(createdPoint.getPosition(), this.newPosition);
                nextAction = ActionFactory.createACMovePoint(this.getActionContext(), createdPoint, distance, true);
            }
        }
        return nextAction;
    }

    public String toString() {
        return "TAInsert2Points ()";
    }
}

