/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.routing;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.routing.AbstractRouter;
import com.arcway.planagent.planmodel.routing.IRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;

public abstract class AbstractSetPointRouter
extends AbstractRouter {
    public AbstractSetPointRouter(Class<? extends IAnchoringDestination> destinationClassToCheck) {
        super(IAnchoringSourcePoint.class, destinationClassToCheck);
    }

    @Override
    public ActionIterator routeWhenClassesAreChecked(IAnchoringSource source, IAnchoringDestination destination, ActionContext actionContext, IRoutingParameters routingParameters, IRoutingManager routingManager) {
        PredeterminedActionIterator actionIterator = null;
        IAnchoringSourcePoint sourcePoint = (IAnchoringSourcePoint)source;
        Point point = this.getTargetPosition(sourcePoint, destination);
        if (point != null) {
            boolean removeSourceAnchorings;
            GeoVector vMove;
            ACMovePoint movePointAction;
            Point fromPointTargetPosition;
            AbstractSetPointRouter fromPointSetPointRouter;
            IRouter fromPointRouter;
            IAnchoringSourcePoint fromPoint;
            IAnchoring fromPointAnchoring;
            boolean dontRoute = false;
            if (sourcePoint.getForce() != IAnchoringSourcePoint.FORCE_NONE && (fromPointAnchoring = (fromPoint = sourcePoint.getAnchoringSourceFromPoint()).getIAnchoring()) != null && (fromPointRouter = routingManager.getRouter(fromPointAnchoring, actionContext.getActionParameters().getRoutingContext())) != null && fromPointRouter instanceof AbstractSetPointRouter && !(fromPointSetPointRouter = (AbstractSetPointRouter)fromPointRouter).justElongatesForcedLines() && (fromPointTargetPosition = fromPointSetPointRouter.getTargetPosition(fromPoint, fromPointAnchoring.getAnchoringDestination())) != null) {
                if (sourcePoint.getForce() == IAnchoringSourcePoint.FORCE_HORIZONTAL) {
                    dontRoute = !Geo.equals((double)fromPointTargetPosition.y, (double)point.y);
                } else if (sourcePoint.getForce() == IAnchoringSourcePoint.FORCE_VERTICAL) {
                    boolean bl = dontRoute = !Geo.equals((double)fromPointTargetPosition.x, (double)point.x);
                }
            }
            if (!dontRoute && (movePointAction = ActionFactory.createACMovePoint(actionContext, sourcePoint, vMove = new GeoVector(sourcePoint.getAnchoringSourcePosition(), point), removeSourceAnchorings = false)) != null && movePointAction.getDistance().equalsGeoVector(vMove)) {
                actionIterator = new PredeterminedActionIterator(1);
                actionIterator.addAction(movePointAction);
            }
        }
        return actionIterator;
    }

    protected abstract boolean justElongatesForcedLines();

    protected abstract Point getTargetPosition(IAnchoringSourcePoint var1, IAnchoringDestination var2);
}

