/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.reactions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ConcatenatingActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import java.util.List;

public class RAResizeGraphSupplAfterChangeGeometryFigure
implements IRAChangeGeometryFigure {
    private static final ILogger logger = Logger.getLogger(RAResizeGraphSupplAfterChangeGeometryFigure.class);

    @Override
    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext context) {
        assert (oldGeometry != null) : "ref to geometry is null";
        ConcatenatingActionIterator reactionIterator = new ConcatenatingActionIterator();
        if (logger.isTraceEnabled()) {
            logger.trace("RAResizeGraphSupplAfterChangeGeometryFigure createReactions(" + figure + ") - start");
        }
        if (figure.getGraphicalSupplementCount() != 0) {
            int i = 0;
            while (i < figure.getGraphicalSupplementCount()) {
                IPMGraphicalSupplementRW graSuppl = figure.getGraphicalSupplementRW(i);
                AbstractResizeSupplementRouter reSupplRouter = graSuppl.getPlanElementRW().getResizeSupplementRouter(graSuppl);
                reactionIterator.addActionIterator(reSupplRouter.createReactionsFigureGeometryChanged(figure, oldGeometry, context));
                ++i;
            }
        } else {
            reactionIterator.addActionIterator(new PredeterminedActionIterator(0));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("createReactions(figure, oldGeometry, ActionContext) - end - return value = " + reactionIterator);
        }
        assert (reactionIterator != null) : "reactionIterator is null";
        return reactionIterator;
    }
}

