/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.geometry.polygon.PolygonCorner;
import com.arcway.lib.geometry.polygon.PolygonLine;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PMPointList;
import com.arcway.planagent.planmodel.implementation.PMViewable;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.EOPlanObject;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.List;

public abstract class PMPlanObject
extends PMViewable
implements IPMPlanObjectRO,
IPMPlanObjectRW {
    private PMPointList pointList;
    private Polygon polygonCache = null;

    protected abstract EOPlanObject getPersistentPlanObject();

    @Override
    protected EOPlanModelObject getPersistentPlanModelObject() {
        return this.getPersistentPlanObject();
    }

    protected PMPlanObject(PlanModelMgr planModelMgr) {
        super(planModelMgr);
    }

    @Override
    protected void linkToChild(PMPlanModelObject child) {
        if (child instanceof PMPointList) {
            this.pointList = (PMPointList)child;
        }
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) {
    }

    @Override
    protected List<PMPlanModelObject> getChildren() {
        ArrayList<PMPlanModelObject> children = new ArrayList<PMPlanModelObject>(1);
        if (this.pointList != null) {
            children.add(this.pointList);
        }
        return children;
    }

    public PMPointList getPointList() {
        return this.pointList;
    }

    @Override
    public IPMPointListRO getPointListRO() {
        return this.getPointList();
    }

    @Override
    public IPMPointListRW getPointListRW() {
        return this.getPointList();
    }

    public void setPointList(PMPointList pointList) {
        this.setPointList((Object)pointList);
    }

    @Override
    public void setPointList(IPMPointListRW pointList) {
        this.setPointList((Object)pointList);
    }

    private void setPointList(Object pointList) {
        PMPointList pMPointList;
        assert (pointList == null || pointList instanceof PMPointList) : "pointList is not instance of PMPointList";
        this.pointList = pMPointList = (PMPointList)pointList;
        if (pMPointList == null) {
            this.getPersistentPlanObject().setPointList(null);
        } else {
            this.getPersistentPlanObject().setPointList(pMPointList.getPersistentPointList());
        }
    }

    protected void constructPMPlanObject() {
        this.setPointList(new PMPointList(this.getPlanModelMgr(), this));
    }

    protected void removeLinks() {
        this.setPointList(null);
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        Rectangle outerBounds = this.getPointUnionWithoutChildren();
        return outerBounds;
    }

    @Override
    public Rectangle getPointUnionWithoutChildren() {
        Rectangle pointUnion = this.getPointList().getPointsBounds();
        return pointUnion;
    }

    public Polygon getPolygon() {
        if (this.polygonCache == null) {
            this.polygonCache = this.createPolygon();
        }
        return this.polygonCache;
    }

    protected abstract Double getWidth();

    protected abstract Polygon createPolygon();

    protected PolygonCorner getPolygonCorner(PMPoint point) {
        Polygon polygon;
        PolygonCorner corner = null;
        int pointIdx = this.getPointList().getPointIndex(point);
        if (pointIdx >= 0 && (polygon = this.getPolygon()) != null) {
            corner = polygon.getPolygonCorner(pointIdx);
        }
        return corner;
    }

    protected PolygonLine getPolygonLine(PMLine line) {
        Polygon polygon;
        PolygonLine polygonLine = null;
        int lineIdx = this.getPointList().getLineIndex(line);
        if (lineIdx >= 0 && (polygon = this.getPolygon()) != null) {
            polygonLine = polygon.getPolygonLine(lineIdx);
        }
        return polygonLine;
    }

    @Override
    protected void flushGeometryCaches() {
        this.flushPolygonCache();
        super.flushGeometryCaches();
        PMPointList pointLst = this.getPointList();
        if (pointLst != null) {
            pointLst.flushGeometryCaches();
        }
    }

    protected void flushPolygonCache() {
        this.polygonCache = null;
    }

    @Override
    public String getViewableName() {
        return null;
    }

    @Override
    public String getViewableTypeID() {
        return this.getPersistentPlanModelObject().getTag();
    }

    @Override
    public String getViewableUID() {
        return null;
    }

    static abstract class PlanObjectFactory
    extends PMPlanModelObject.PlanModelObjectFactory {
        PlanObjectFactory() {
        }

        @Override
        public List<? extends EOEncodableObject> getChildren(EncodableObjectBase eo) {
            EOPlanObject eoPlanObject = (EOPlanObject)eo;
            List<? extends EOEncodableObject> children = super.getChildren(eo);
            children.add((EOEncodableObject)eoPlanObject.getPointList());
            return children;
        }
    }
}

