/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeRootListener;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeRootMgrRO;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRootMgrRW;
import com.arcway.planagent.planmodel.implementation.ModelChange;
import com.arcway.planagent.planmodel.implementation.ModelChangeMgr;
import java.util.HashSet;
import java.util.Set;

public class ModelChangeRootMgr
implements IModelChangeRootMgrRO,
IModelChangeRootMgrRW {
    private static final ILogger logger = Logger.getLogger(ModelChangeMgr.class);
    private final Set modelChangeListeners = new HashSet();

    @Override
    public void addModelChangeRootListener(IModelChangeRootListener modelChangeListener) {
        this.modelChangeListeners.add(modelChangeListener);
    }

    @Override
    public void removeModelChangeRootListener(IModelChangeRootListener modelChangeListener) {
        this.modelChangeListeners.remove(modelChangeListener);
    }

    public void aboutTofireModelChanges(Set modelChanges) {
        if (logger.isDebugEnabled(55)) {
            logger.debug(55, "   __ About to Fire Model Change Events: ");
            for (ModelChange modelChange : modelChanges) {
                logger.debug(55, "      - " + modelChange.toString());
            }
            logger.debug(55, "      to root listeners: ");
            for (IModelChangeRootListener modelChangeRootListener : this.modelChangeListeners) {
                logger.debug(55, "      - " + modelChangeRootListener.toString());
            }
        }
        if (modelChanges.size() > 0) {
            for (IModelChangeRootListener modelChangeRootListener : this.modelChangeListeners) {
                modelChangeRootListener.aboutTofireModelChanges(modelChanges);
            }
        }
    }

    public void modelChangesFired(Set modelChanges) {
        if (logger.isDebugEnabled(55)) {
            logger.debug(55, "   __ Model Change Events fired: ");
            for (ModelChange modelChange : modelChanges) {
                logger.debug(55, "      - " + modelChange.toString());
            }
            logger.debug(55, "      to root listeners: ");
            for (IModelChangeRootListener modelChangeRootListener : this.modelChangeListeners) {
                logger.debug(55, "      - " + modelChangeRootListener.toString());
            }
        }
        if (modelChanges.size() > 0) {
            for (IModelChangeRootListener modelChangeRootListener : this.modelChangeListeners) {
                modelChangeRootListener.modelChangesFired(modelChanges);
            }
        }
    }
}

