/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.actions.ACSetPositionAnchor;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;

public class ACSetPositionAnchorOffSet
extends ACSetPositionAnchor {
    private final GeoVector offSet;
    private GeoVector oldOffSet;

    public ACSetPositionAnchorOffSet(ActionContext actionContext, IPMAnchorRW anchor, GeoVector offSet) {
        super(actionContext, anchor);
        assert (offSet != null) : "ref to GeoVector is null";
        this.offSet = offSet;
    }

    @Override
    protected void initializeState() {
        this.oldOffSet = this.getAnchor().getOffset();
    }

    @Override
    protected void setStateToPost() {
        this.getAnchor().setOffset(this.offSet);
    }

    @Override
    protected void setStateToPre() {
        this.getAnchor().setOffset(this.oldOffSet);
    }

    @Override
    public boolean isDupe(Action a) {
        ACSetPositionAnchorOffSet dupeA;
        boolean isDupe = false;
        if (a instanceof ACSetPositionAnchorOffSet && (dupeA = (ACSetPositionAnchorOffSet)a).getAnchor() == this.getAnchor() && dupeA.getOffSet() == this.getOffSet()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    public GeoVector getOffSet() {
        return this.offSet;
    }

    public String toString() {
        return "ACSetPositionAnchorOffSet (offset " + this.offSet + ")";
    }
}

