/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.java.New;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class ACCreateAnchor
extends Action {
    private final IPMLineRW line;
    private IPMAnchorRW anchor;
    private int index;

    public ACCreateAnchor(ActionContext actionContext, IPMLineRW line) {
        super(actionContext);
        assert (line != null) : "ref to line is null";
        this.line = line;
    }

    @Override
    protected void initializeState() {
        this.anchor = this.getIPlanModelObjectFactoryRW().createPMAnchorRW();
        this.anchor.setLine(this.line);
        this.index = this.line.getAnchorCount();
    }

    @Override
    protected void setStateToPost() {
        assert (this.index == this.line.getAnchorCount()) : "the index has not the expected value";
        this.line.addAnchor(this.anchor, this.index);
    }

    @Override
    protected void setStateToPre() {
        assert (this.line.getAnchorIndex(this.anchor) == this.index) : "anchor is not at the expected index";
        this.line.removeAnchor(this.index);
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.anchor, 1));
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        IPMPlanObjectRW planObject = this.line.getPlanObjectRW();
        if (planObject instanceof IPMFigureRW) {
            IPMFigureRW figure = (IPMFigureRW)planObject;
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionChangeGeometryAttributeFigureAgent().getEntryForCompressedList(figure, this.getActionContext()));
        }
        if (planObject instanceof IPMGraphicalSupplementRW) {
            HashMap changedSupplements = New.hashMap((int)1);
            changedSupplements.put((IPMGraphicalSupplementRW)planObject, null);
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionModifySupplementAgent().getEntryForCompressedList(changedSupplements, this.getActionContext()));
        }
        assert (false) : "point not part of supplement or figure";
        return null;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.line.getPlanElementRW();
    }

    public IPMLineRW getLine() {
        return this.line;
    }

    public IPMAnchorRW getAnchor() {
        return this.anchor;
    }
}

