/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.bd.persistent;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.fmc.bd.appearance.FMCBDRequestSymbolAppearance;
import com.arcway.planagent.planmodel.fmc.bd.appearance.IFMCBDRequestSymbolAppearance;
import com.arcway.planagent.planmodel.fmc.bd.appearance.IFMCBDRequestSymbolAppearanceRO;
import de.plans.lib.xml.encoding.EAEncodableAttributes;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class EARequestSymbolFMCBDAppearance
extends EAEncodableAttributes
implements IFMCBDRequestSymbolAppearance {
    private static final ILogger logger = Logger.getLogger(EARequestSymbolFMCBDAppearance.class);
    private static final String ATTR_TAG_SIZE = "size";
    private static final String ATTR_TAG_COLOR_RED = "color.red";
    private static final String ATTR_TAG_COLOR_GREEN = "color.green";
    private static final String ATTR_TAG_COLOR_BLUE = "color.blue";
    private static final String ATTR_TAG_COLOR_TRANSPARENT = "color.transparent";
    private static final String ATTR_TAG_DIRECTION = "direction";
    private double size = 2.5;
    private Color color = new Color(0, 0, 0);
    private Direction direction = DEFAULT_DIRECTION;

    public EARequestSymbolFMCBDAppearance(String attrTagPrefix) {
        super(attrTagPrefix);
        if (logger.isDebugEnabled()) {
            logger.debug(51, "EARequestSymbolAppearance(String attrTagPrefix = " + attrTagPrefix + ") - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "EARequestSymbolAppearance(String) - end");
        }
    }

    public EARequestSymbolFMCBDAppearance(EAEncodableAttributes ea, String xmlAttrTag) {
        super(ea, xmlAttrTag);
        if (logger.isDebugEnabled()) {
            logger.debug(51, "EARequestSymbolAppearance(EAEncodableAttributes ea = " + ea + ", String xmlAttrTag = " + xmlAttrTag + ") - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "EARequestSymbolAppearance(EAEncodableAttributes, String) - end");
        }
    }

    public void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "appendAttributesToXML(OutputStream outp = " + writeContext + ") - start");
        }
        assert (writeContext != null) : "outp is NULL.";
        if (Math.abs(this.size - 2.5) >= 1.0E-10) {
            this.appendAttrToXML(writeContext, ATTR_TAG_SIZE, this.size);
        }
        if (this.color.transparent) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_TRANSPARENT, this.color.transparent);
        }
        if (!(this.color.r == 0 && this.color.g == 0 && this.color.b == 0 || this.color.transparent)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_RED, this.color.r);
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_GREEN, this.color.g);
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_BLUE, this.color.b);
        }
        if (!this.direction.equalsDirection(DEFAULT_DIRECTION)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_DIRECTION, this.direction.getAngle());
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "appendAttributesToXML(OutputStream) - end");
        }
    }

    protected boolean setSubAttributeFromXML(String name, String value) {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setSubAttributeFromXML(String name = " + name + ", String value = " + value + ") - start");
        }
        boolean knownAttribute = true;
        if (ATTR_TAG_SIZE.equals(name)) {
            this.size = this.toDouble(value);
        } else if (ATTR_TAG_COLOR_RED.equals(name)) {
            this.color.r = this.toInt(value);
        } else if (ATTR_TAG_COLOR_GREEN.equals(name)) {
            this.color.g = this.toInt(value);
        } else if (ATTR_TAG_COLOR_BLUE.equals(name)) {
            this.color.b = this.toInt(value);
        } else if (ATTR_TAG_COLOR_TRANSPARENT.equals(name)) {
            this.color.transparent = this.toBoolean(value);
        } else if (ATTR_TAG_DIRECTION.equals(name)) {
            double angle = this.toDouble(value);
            this.direction = Direction.valueOf((double)angle);
        } else {
            knownAttribute = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setSubAttributeFromXML(String, String) - end - return value = " + knownAttribute);
        }
        return knownAttribute;
    }

    @Override
    public void setColor(Color color) {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setColor(Color color = " + color + ") - start");
        }
        assert (color != null) : "color is NULL.";
        this.color = new Color(color);
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setColor(Color) - end");
        }
    }

    @Override
    public void setSize(double size) {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setSize(double size = " + size + ") - start");
        }
        assert (size >= 0.0) : "size is less than 0";
        this.size = size;
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setSize(double) - end");
        }
    }

    @Override
    public void setDirection(Direction direction) {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setDirection(Direction direction = " + direction + ") - start");
        }
        this.direction = direction;
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setDirection(direction) - end");
        }
    }

    @Override
    public Color getColor() {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "getColor() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "getColor() - end - return value = " + this.color);
        }
        return new Color(this.color);
    }

    @Override
    public double getSize() {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "getSize() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "getSize() - end - return value = " + this.size);
        }
        return this.size;
    }

    @Override
    public Direction getDirection() {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "getDirection() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "getDirection() - end - return value = " + this.direction);
        }
        return this.direction;
    }

    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof IFMCBDRequestSymbolAppearanceRO)) {
            return;
        }
        IFMCBDRequestSymbolAppearanceRO rs = (IFMCBDRequestSymbolAppearanceRO)appearance;
        this.setColor(rs.getColor());
        this.setSize(rs.getSize());
        this.setDirection(rs.getDirection());
    }

    public IAppearanceRO getAppearanceAsCopy() {
        return new FMCBDRequestSymbolAppearance(this);
    }
}

