/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.base.transactions;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;

public class LineHelper {
    public static int[] createAlternatingLineForcesClosed(Points p) throws EXTransactionNotValidException {
        int[] force = new int[p.size()];
        LineHelper.transactionAssertion(p.size() >= 1, "points has no points");
        if (force.length > 0) {
            LineHelper.transactionAssertion(!p.get(0).equalsPoint(p.get(1)), "1st line has lenght 0");
            if (Geo.equals((double)p.get((int)0).y, (double)p.get((int)1).y)) {
                force[0] = 2;
            } else if (Geo.equals((double)p.get((int)0).x, (double)p.get((int)1).x)) {
                force[0] = 3;
            } else {
                LineHelper.transactionAssertion(false, "first line is diagonal");
            }
            int i = 1;
            while (i < force.length) {
                if (force[i - 1] == 2) {
                    force[i] = 3;
                    if (i < force.length - 1) {
                        LineHelper.transactionAssertion(Geo.equals((double)p.get((int)i).x, (double)p.get((int)(i + 1)).x), "line " + i + " is not vertical");
                    } else {
                        LineHelper.transactionAssertion(Geo.equals((double)p.get((int)i).x, (double)p.get((int)0).x), "line " + i + " is not vertical");
                    }
                } else {
                    force[i] = 2;
                    if (i < force.length - 1) {
                        LineHelper.transactionAssertion(Geo.equals((double)p.get((int)i).y, (double)p.get((int)(i + 1)).y), "line " + i + " is not horizontal");
                    } else {
                        LineHelper.transactionAssertion(Geo.equals((double)p.get((int)i).y, (double)p.get((int)0).y), "line " + i + " is not horizontal");
                    }
                }
                ++i;
            }
        }
        return force;
    }

    public static int[] createAlternatingLineForcesOpen(Points p) throws EXTransactionNotValidException {
        int[] force = new int[p.size() - 1];
        LineHelper.transactionAssertion(p.size() >= 1, "points has no points");
        if (force.length > 0) {
            LineHelper.transactionAssertion(!p.get(0).equalsPoint(p.get(1)), "1st line has lenght 0");
            if (Geo.equals((double)p.get((int)0).y, (double)p.get((int)1).y)) {
                force[0] = 2;
            } else if (Geo.equals((double)p.get((int)0).x, (double)p.get((int)1).x)) {
                force[0] = 3;
            } else {
                LineHelper.transactionAssertion(false, "first line is diagonal");
            }
            int i = 1;
            while (i < force.length) {
                if (force[i - 1] == 2) {
                    force[i] = 3;
                    LineHelper.transactionAssertion(Geo.equals((double)p.get((int)i).x, (double)p.get((int)(i + 1)).x), "line " + i + "is not vertical");
                } else {
                    force[i] = 2;
                    LineHelper.transactionAssertion(Geo.equals((double)p.get((int)i).y, (double)p.get((int)(i + 1)).y), "line " + i + "is not horizontal");
                }
                ++i;
            }
        }
        return force;
    }

    public static Points createModifyingEdge(Points geometryLine, double centerDist, double endDist) throws EXTransactionNotValidException {
        Point via;
        Point to;
        Point from;
        LineHelper.transactionAssertion(geometryLine.size() >= 2, "points not definig a line");
        Point start = geometryLine.get(0);
        Point end = geometryLine.get(1);
        Point center = new Line(start, end).getCenter();
        if (!start.equalsPoint(end)) {
            GeoVector walkAtStartAndEnd = new GeoVector(start, end).turn90().scaleToLength(endDist);
            GeoVector walkAtCenter = walkAtStartAndEnd.scaleToLength(centerDist);
            from = start.movePoint(walkAtStartAndEnd);
            to = end.movePoint(walkAtStartAndEnd);
            if (Geo.equals((double)endDist, (double)centerDist)) {
                via = center.movePoint(walkAtCenter);
            } else {
                Point touches = center.movePoint(walkAtCenter);
                Arc arc = Arc.createArcByArcPoints((Point)from, (Point)touches, (Point)to);
                if (arc != null) {
                    via = arc.getVia();
                    if (via == null) {
                        via = center.movePoint(walkAtCenter);
                    }
                } else {
                    via = center.movePoint(walkAtCenter);
                }
            }
        } else {
            from = start;
            via = center;
            to = end;
        }
        Points points = new Points();
        points.add(from);
        points.add(via);
        points.add(to);
        return points;
    }

    private static void transactionAssertion(boolean condition, String message) throws EXTransactionNotValidException {
        if (!condition) {
            throw new EXTransactionNotValidException(message);
        }
    }
}

