/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpmn.bpd.implementation;

import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.anchoring.AnchoringContributorTraverser;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.base.access.readonly.IAlignmentProvider;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithLineShapeOutlineRO;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithOutlineRO;
import com.arcway.planagent.planmodel.base.implementation.PMPlanElementWithPlaneOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planmodel.base.transactions.ForceRectangularOutlineFigureTransactionValidator;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMGraphicalSupplementBPMNBPDLogicalOperatorSymbolRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMGraphicalSupplementBPMNBPDLogicalOperatorSymbolRW;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDGatewayRW;
import com.arcway.planagent.planmodel.bpmn.bpd.implementation.PMGraphicalSupplementBPMNBPDLogicalOperatorSymbol;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementTextRO;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.routing.ResizeSupplementFittingStraightLineRouter;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMFigurePlane;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PMPlanElementBPMNBPDGateway
extends PMPlanElementWithPlaneOutlineAndNameAndDescriptionSupplement
implements IPMPlanElementBPMNBPDGatewayRW,
IAlignmentProvider {
    public static final String XML_TYPE = "bpmn.bpd.gateway";
    public static final String XML_FIGURE_GATEWAY_ROLE = "gateway";
    public static final String XML_FIGURE_GEOMETRYFIGURE_ROLE = "geometryFigure";
    public static final String XML_SUPPLEMENT_COMMENT_ROLE = "comment";
    public static final String XML_SUPPLEMENT_SYMBOL_ROLE = "symbol";

    @Deprecated
    public PMPlanElementBPMNBPDGateway(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    @Deprecated
    public PMPlanElementBPMNBPDGateway(PlanModelMgr planModelMgr, EOPlanElement eo) {
        super(planModelMgr, eo);
    }

    public TopologyType getToplogyType() {
        return TopologyType.DEEP;
    }

    public Action createSetCommentAction(String comment, ActionContext actionContext) {
        PMGraphicalSupplementText graphicalSupplementText = this.getComment();
        return graphicalSupplementText == null ? null : new ACSetTextGraphicalSupplementText(actionContext, (IPMGraphicalSupplementTextRW)graphicalSupplementText, comment);
    }

    public IPMGraphicalSupplementTextRO getCommentRO() {
        return this.getComment();
    }

    public IPMGraphicalSupplementTextRW getCommentRW() {
        return this.getComment();
    }

    public String getCommentTextRole() {
        return XML_SUPPLEMENT_COMMENT_ROLE;
    }

    public Collection<IPMFigureRO> getEditFigures() {
        return Collections.singleton(this.getGeometryFigure());
    }

    @Override
    public IPMFigurePlaneRO getGatewayFigureRO() {
        return this.getGatewayFigure();
    }

    @Override
    public IPMFigurePlaneRW getGatewayFigureRW() {
        return this.getGatewayFigure();
    }

    public IPMFigureRW getFigureToCommentRW() {
        return this.getGeometryFigure();
    }

    @Override
    public IPMFigurePlaneRO getGeometryFigureRO() {
        return (IPMFigurePlaneRO)this.getGeometryFigure();
    }

    @Override
    public IPMFigurePlaneRW getGeometryFigureRW() {
        return (IPMFigurePlaneRW)this.getGeometryFigure();
    }

    public PMFigure getOutlineFigure() {
        return this.getGeometryFigure();
    }

    protected PMFigure getNestingInlineFigure() {
        return this.getGatewayFigure();
    }

    protected IPMPlanObjectRO getProjectionAreaDefiningPlanObject() {
        return this.getGatewayFigure();
    }

    public AbstractResizeSupplementRouter getResizeSupplementRouter(IPMGraphicalSupplementRW graphSuppl) {
        assert (graphSuppl != null) : "ref to graphSuppl is null";
        assert (this.getPlanElementRW().equals(graphSuppl.getPlanElementRW())) : "the graSuppl does not belong to this planelement";
        if (XML_SUPPLEMENT_SYMBOL_ROLE.equals(graphSuppl.getRole())) {
            return new ResizeSupplementFittingStraightLineRouter(graphSuppl);
        }
        return super.getResizeSupplementRouter(graphSuppl);
    }

    public ITransactionValidator getTransactionValidator() {
        return new ForceRectangularOutlineFigureTransactionValidator((IPMPlanElementWithOutlineRO)this, true);
    }

    public int getNumberOfIncomingEdges() {
        int pointCount = 0;
        PMFigurePlane outlineFigure = this.getGatewayFigure();
        ArrayList<PMFigurePlane> destinationContributors = new ArrayList<PMFigurePlane>();
        destinationContributors.add(outlineFigure);
        Collection anchorings = AnchoringContributorTraverser.getAllAnchorings(Collections.emptyList(), destinationContributors);
        for (IAnchoring anchoring : anchorings) {
            IPMFigureRO figure = anchoring.getAnchoringSource().getAnchoringFigure();
            if (!(figure.getPlanElementRO() instanceof IPMPlanElementWithLineShapeOutlineRO)) continue;
            IPMFigureLineShapeRO edge = ((IPMPlanElementWithLineShapeOutlineRO)figure.getPlanElementRO()).getOutlineFigureLineShapeRO();
            IPMPointRO anchorPoint = ((IPMAnchoringPointRO)anchoring).getPointRO();
            IPMPointListRO edgePoints = edge.getPointListRO();
            IPMPointRO startPoint = edgePoints.getPointRO(0);
            IPMPointRO endPoint = edgePoints.getPointRO(edge.getPointListRO().getPointCount() - 1);
            if (edge.getLineStartMarkerAppearanceRO().getLineMarkerStyle() != LineMarker.NONE && startPoint.equals(anchorPoint)) {
                ++pointCount;
            }
            if (edge.getLineEndMarkerAppearanceRO().getLineMarkerStyle() == LineMarker.NONE || !endPoint.equals(anchorPoint)) continue;
            ++pointCount;
        }
        return pointCount;
    }

    public int getNumberOfOutgoingEdges() {
        int pointCount = 0;
        PMFigurePlane outlineFigure = this.getGatewayFigure();
        ArrayList<PMFigurePlane> destinationContributors = new ArrayList<PMFigurePlane>();
        destinationContributors.add(outlineFigure);
        Collection anchorings = AnchoringContributorTraverser.getAllAnchorings(Collections.emptyList(), destinationContributors);
        for (IAnchoring anchoring : anchorings) {
            IPMFigureRO figure = anchoring.getAnchoringSource().getAnchoringFigure();
            if (!(figure.getPlanElementRO() instanceof IPMPlanElementWithLineShapeOutlineRO)) continue;
            IPMFigureLineShapeRO edge = ((IPMPlanElementWithLineShapeOutlineRO)figure.getPlanElementRO()).getOutlineFigureLineShapeRO();
            IPMPointRO anchorPoint = ((IPMAnchoringPointRO)anchoring).getPointRO();
            IPMPointListRO edgePoints = edge.getPointListRO();
            IPMPointRO startPoint = edgePoints.getPointRO(0);
            IPMPointRO endPoint = edgePoints.getPointRO(edge.getPointListRO().getPointCount() - 1);
            if (edge.getLineStartMarkerAppearanceRO().getLineMarkerStyle() == LineMarker.NONE && startPoint.equals(anchorPoint)) {
                ++pointCount;
            }
            if (edge.getLineEndMarkerAppearanceRO().getLineMarkerStyle() != LineMarker.NONE || !endPoint.equals(anchorPoint)) continue;
            ++pointCount;
        }
        return pointCount;
    }

    public boolean isIncomingEdge(IPMFigureRO sourceFigure) {
        PMFigurePlane outlineFigure = this.getGatewayFigure();
        ArrayList<PMFigurePlane> destinationContributors = new ArrayList<PMFigurePlane>();
        destinationContributors.add(outlineFigure);
        Collection anchorings = AnchoringContributorTraverser.getAllAnchorings(Collections.emptyList(), destinationContributors);
        for (IAnchoring anchoring : anchorings) {
            IPMFigureRO figure = anchoring.getAnchoringSource().getAnchoringFigure();
            if (!figure.equals(sourceFigure)) continue;
            IPMFigureLineShapeRO edge = ((IPMPlanElementWithLineShapeOutlineRO)sourceFigure.getPlanElementRO()).getOutlineFigureLineShapeRO();
            IPMPointRO anchorPoint = ((IPMAnchoringPointRO)anchoring).getPointRO();
            IPMPointListRO edgePoints = edge.getPointListRO();
            IPMPointRO endPoint = edgePoints.getPointRO(edge.getPointListRO().getPointCount() - 1);
            if (!endPoint.equals(anchorPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutgoingEdge(IPMFigureRO sourceFigure) {
        PMFigurePlane outlineFigure = this.getGatewayFigure();
        ArrayList<PMFigurePlane> destinationContributors = new ArrayList<PMFigurePlane>();
        destinationContributors.add(outlineFigure);
        Collection anchorings = AnchoringContributorTraverser.getAllAnchorings(Collections.emptyList(), destinationContributors);
        for (IAnchoring anchoring : anchorings) {
            IPMFigureRO figure = anchoring.getAnchoringSource().getAnchoringFigure();
            if (!figure.equals(sourceFigure)) continue;
            IPMFigureLineShapeRO edge = ((IPMPlanElementWithLineShapeOutlineRO)sourceFigure.getPlanElementRO()).getOutlineFigureLineShapeRO();
            IPMPointRO anchorPoint = ((IPMAnchoringPointRO)anchoring).getPointRO();
            IPMPointListRO edgePoints = edge.getPointListRO();
            IPMPointRO startPoint = edgePoints.getPointRO(0);
            if (!startPoint.equals(anchorPoint)) continue;
            return true;
        }
        return false;
    }

    public PMGraphicalSupplementText getNameSupplement() {
        PMGraphicalSupplementText supplement = null;
        PMFigure geometryFigure = this.getGeometryFigure();
        ArrayList textSupplements = geometryFigure == null ? new ArrayList(1) : geometryFigure.getGraphicalSupplements("nameSupplement");
        PMFigurePlane gatewayFigure = this.getGatewayFigure();
        if (gatewayFigure != null) {
            textSupplements.addAll(gatewayFigure.getGraphicalSupplements("nameSupplement"));
        }
        if (textSupplements.size() == 1) {
            supplement = (PMGraphicalSupplementText)textSupplements.get(0);
        }
        return supplement;
    }

    private PMGraphicalSupplementText getComment() {
        PMFigure outlineFigure = this.getGeometryFigure();
        assert (outlineFigure != null);
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_COMMENT_ROLE);
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1);
        return (PMGraphicalSupplementText)supplementRefs.get(0);
    }

    private PMFigurePlane getGatewayFigure() {
        List figures = this.getFiguresRO(XML_FIGURE_GATEWAY_ROLE);
        if (figures.size() == 0) {
            return null;
        }
        assert (figures.get(0) instanceof PMFigurePlane);
        assert (figures.size() == 1) : "more than one event figure found";
        return (PMFigurePlane)figures.get(0);
    }

    private PMFigure getGeometryFigure() {
        List figures = this.getFiguresRO(XML_FIGURE_GEOMETRYFIGURE_ROLE);
        if (figures.size() == 0) {
            return null;
        }
        assert (figures.get(0) instanceof PMFigurePlane);
        assert (figures.size() == 1);
        return (PMFigure)figures.get(0);
    }

    public boolean hasRelevantGeometryAdaption() {
        return false;
    }

    @Override
    public IPMGraphicalSupplementBPMNBPDLogicalOperatorSymbolRO getLogicalOperatorSymbolRO() {
        return this.getSymbol();
    }

    @Override
    public IPMGraphicalSupplementBPMNBPDLogicalOperatorSymbolRW getLogicalOperatorSymbolRW() {
        return this.getSymbol();
    }

    private PMGraphicalSupplementBPMNBPDLogicalOperatorSymbol getSymbol() {
        PMFigure outlineFigure = this.getGeometryFigure();
        assert (outlineFigure != null) : "outlineFigure is NULL.";
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_SYMBOL_ROLE);
        assert (supplementRefs != null) : "supplementRefs is NULL.";
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1) : "not exactly one reference was found";
        return (PMGraphicalSupplementBPMNBPDLogicalOperatorSymbol)supplementRefs.get(0);
    }

    public IPMPlanObjectRO.PlanObjectEditType getFigureEditType(IPMFigureRO figure) {
        IPMPlanObjectRO.PlanObjectEditType editType = figure == this.getGeometryFigure() || figure == this.getGatewayFigure() ? IPMPlanObjectRO.FIGURE_EDIT_TYPE_HALF_NODE : super.getFigureEditType(figure);
        return editType;
    }

    public Alignment getDefaultNameAlignment() {
        return new Alignment(1, 16);
    }

    public boolean isHighlightableFigure(PMFigure figureToCheck) {
        boolean isEventFigure = figureToCheck.getRole().equals(XML_FIGURE_GATEWAY_ROLE);
        return isEventFigure && super.isHighlightableFigure(figureToCheck);
    }
}

