/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planexporter;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.planagent.IInternalAbstractPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planexporter.IPlanExporterExtension;
import com.arcway.planagent.controllinginterface.planexporter.PlanExporterInputExtension;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planview.frameview.FrameViewConfig;
import com.arcway.planagent.planview.print.PrintProcessor;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import com.arcway.planagent.planview.view.PVTransformedViewPart;
import com.arcway.planagent.planview.view.PVView;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import com.arcway.planagent.planview.viewcreator.ViewCreator;
import com.arcway.planagent.planviewer.PlanViewerExtension;
import de.plans.lib.util.gui.IProgressDisplay;
import java.util.Set;

public class PlanExporter
extends PlanViewerExtension
implements IPlanExporterExtension {
    private final IInternalAbstractPlanAgent abstractPlanAgent;
    private PVView viewCache = null;
    private boolean showProjections = true;
    private boolean showHighlights = true;
    private boolean showComments = true;
    private boolean showInformation = true;
    private double angle = 0.0;

    public PlanExporter(IInternalAbstractPlanAgent abstractPlanAgent, PlanExporterInputExtension input, IProgressDisplay loadProgressDisplay) throws EXSetupPlanException {
        super(abstractPlanAgent, loadProgressDisplay);
        this.abstractPlanAgent = abstractPlanAgent;
    }

    public void close() {
        this.abstractPlanAgent.closePlan();
    }

    public Rectangle getViewSize() {
        return this.getView().calculateBounds();
    }

    public void export(IPrinter printer, PageSetup hints) throws PrintingFailure {
        PrintProcessor pp = new PrintProcessor();
        pp.print(printer, this.getView(), hints, this.abstractPlanAgent.getPlanInfo().getPlanName());
    }

    public void showProjections() {
        this.showProjections = true;
        this.flushViewCache();
    }

    public void hideProjections() {
        this.showProjections = false;
        this.flushViewCache();
    }

    public void showHighlights() {
        this.showHighlights = true;
        this.flushViewCache();
    }

    public void hideHighlights() {
        this.showHighlights = false;
        this.flushViewCache();
    }

    public void showComments() {
        this.showComments = true;
        this.flushViewCache();
    }

    public void hideComments() {
        this.showComments = false;
        this.flushViewCache();
    }

    public void showInformation() {
        this.showInformation = true;
        this.flushViewCache();
    }

    public void hideInformation() {
        this.showInformation = false;
        this.flushViewCache();
    }

    public void setRotation(double angle) {
        this.angle = angle;
        this.flushViewCache();
    }

    protected void viewerModelsChanged(Set modelChanges) {
        this.flushViewCache();
    }

    private void flushViewCache() {
        this.viewCache = null;
    }

    private PVView getView() {
        if (this.viewCache == null) {
            PVView newView;
            IEditorContent content = new IEditorContent(){

                public IPlanInfo getPlanInfo() {
                    return PlanExporter.this.abstractPlanAgent.getPlanInfo();
                }

                public IPMPlanRO getPlanModel() {
                    return PlanExporter.this.getPlan();
                }
            };
            ViewCreator creator = new ViewCreator();
            FrameViewConfig frameViewConfig = null;
            if (this.showInformation) {
                frameViewConfig = FrameViewConfig.createFrame((Insets)new Insets(10.0), (double)10.0, (double)1.0);
            }
            PVView newViewUntransformed = creator.createPVView(content, null, this.showComments, (HighlightLevel)(this.showHighlights ? HighlightLevel.BUSINESS : null), this.showProjections, frameViewConfig);
            TransformationAffiliate transformation = TransformationAffiliate.newTransformationNOP();
            if (!Geo.isZero((double)this.angle)) {
                transformation.rotate(this.angle);
            }
            if (transformation.isNOPTransformation()) {
                newView = newViewUntransformed;
            } else {
                PVTransformedViewPart transformedViewPart = new PVTransformedViewPart((PVPlanViewPart)newViewUntransformed);
                transformedViewPart.setPlan2canvasTrafo(transformation);
                newView = new PVView();
                newView.addChild((PVPlanViewPart)transformedViewPart);
            }
            this.viewCache = newView;
        }
        return this.viewCache;
    }
}

