/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEKeyDown;
import com.arcway.planagent.planeditor.tools.IInputState;
import com.arcway.planagent.planeditor.tools.InputEvent;
import com.arcway.planagent.planeditor.tools.ZoomTool;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Cursor;

public class IPKeyEnableMagnify
extends AbstractInputProcessor {
    private static final ILogger logger = Logger.getLogger(IPKeyEnableMagnify.class);
    private Request request;

    public IPKeyEnableMagnify(GenericTool tool) {
        super(tool);
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    @Override
    public int handleEvent(InputEvent event) {
        IInputState state;
        if (event instanceof IEKeyDown && (state = this.getTool().getState()).isControlKeyDown() && state.isShiftKeyDown()) {
            this.handleShiftCtrl();
            return 1;
        }
        return 0;
    }

    private void handleShiftCtrl() {
        if (logger.isDebugEnabled()) {
            logger.debug(61, "handleShiftCtrl() - start");
        }
        ZoomTool newZoomTool = new ZoomTool();
        newZoomTool.setKeyActivated(true);
        this.getTool().setToolToSwitchTo(newZoomTool, true);
        if (logger.isDebugEnabled()) {
            logger.debug(61, "handleShiftCtrl() - end");
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public Cursor getCursor() {
        return null;
    }
}

