/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.standalone;

import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.UpdatedAbstractPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.INameAndDescriptionAndCommentAndAspectID;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planagent.NameAndDescriptionAndCommentAndAspectID;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorCommand;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerCommand;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.controllinginterface.planeditor.PlanAgentPlanElementMapping;
import com.arcway.planagent.planeditor.dialogs.DialogFacade;
import com.arcway.planagent.planeditor.standalone.StandalonePlanInfo;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public class StandalonePlanEditorControllerExtension
implements IPlanEditorControllerExtension {
    private static final ILogger logger = Logger.getLogger(StandalonePlanEditorControllerExtension.class);
    private final IEditorSite site;
    private IPathEditorInput input;
    private final UpdatedAbstractPlanAgent abstractPlanAgent;

    public StandalonePlanEditorControllerExtension(IEditorSite site, IPathEditorInput originalInput, UpdatedAbstractPlanAgent abstractPlanAgent) {
        assert (site != null);
        assert (originalInput != null);
        assert (abstractPlanAgent != null);
        this.site = site;
        this.input = originalInput;
        this.abstractPlanAgent = abstractPlanAgent;
    }

    public int isDropOnPlanAllowed(int modesAllowed, int modeWished, Object data) {
        return 0;
    }

    public int isDropOnPlanElementAllowed(IPlanAgentPlanElement planElement, int modesAllowed, int modeWished, Object data) {
        return 0;
    }

    public void dropOnPlan(int mode, Object data) {
    }

    public void dropOnPlanElement(IPlanAgentPlanElement planElement, int modesAllowed, int mode, Object data) {
    }

    public void renamePlanRequest(String newName, IPlanEditorCommand editorCommand) {
    }

    public void createPlanElementsRequest(List<? extends IPlanAgentPlanElement> planElements, Collection<? extends PlanAgentPlanElementMapping> mapping, Collection<? extends MultipleObjectTransferContent> nativeContent, IPlanEditorCommand editorCommand) {
        String planElementUID = null;
        String newElementsName = null;
        for (IPlanAgentPlanElement iPlanAgentPlanElement : planElements) {
            String name = iPlanAgentPlanElement.getPlanElementName();
            if (name == null || name.length() <= 0) continue;
            if (planElementUID == null) {
                planElementUID = iPlanAgentPlanElement.getPlanElementUID();
                newElementsName = name;
                continue;
            }
            newElementsName = null;
        }
        if (newElementsName != null) {
            final String string = planElementUID;
            final String newNameFromTemplate = newElementsName;
            editorCommand.setMgrCommand(new IPlanEditorControllerCommand(){
                private INameAndDescriptionAndCommentAndAspectID newName;

                public boolean canExecuteInGeneral() {
                    return true;
                }

                public boolean canExecuteNow() {
                    Shell shell = StandalonePlanEditorControllerExtension.this.site.getShell();
                    String newNameString = DialogFacade.launchChangeNameDialog(shell, newNameFromTemplate);
                    this.newName = newNameString != null ? new NameAndDescriptionAndCommentAndAspectID(newNameString, null, null, null) : null;
                    boolean canExecute = this.newName != null;
                    return canExecute;
                }

                public boolean makesPlanRelatedChanges() {
                    return true;
                }

                public void execute() {
                    StandalonePlanEditorControllerExtension.this.abstractPlanAgent.setPlanElementNames(Collections.singletonMap(string, this.newName));
                }

                public boolean canUndoNow() {
                    return true;
                }

                public void undo() {
                }

                public void redo() {
                    this.execute();
                }
            });
        }
    }

    public void renamePlanElementRequest(final IPlanAgentPlanElement planElement, IPlanEditorCommand editorCommand) {
        NameAndDescriptionAndCommentAndAspectID oldName = new NameAndDescriptionAndCommentAndAspectID(planElement.getPlanElementName(), planElement.getPlanElementDescription(), null, null);
        String planElementUID = planElement.getPlanElementUID();
        editorCommand.setMgrCommand(new IPlanEditorControllerCommand((INameAndDescriptionAndCommentAndAspectID)oldName, planElementUID){
            INameAndDescriptionAndCommentAndAspectID newName;
            private final /* synthetic */ INameAndDescriptionAndCommentAndAspectID val$oldName;
            private final /* synthetic */ String val$planElementUID;
            {
                this.val$oldName = iNameAndDescriptionAndCommentAndAspectID;
                this.val$planElementUID = string;
            }

            public boolean canExecuteInGeneral() {
                return true;
            }

            public boolean canExecuteNow() {
                Shell shell = StandalonePlanEditorControllerExtension.this.site.getShell();
                String newNameString = DialogFacade.launchChangeNameDialog(shell, planElement.getPlanElementName());
                this.newName = newNameString != null ? new NameAndDescriptionAndCommentAndAspectID(newNameString, this.val$oldName.getDescription(), null, null) : null;
                boolean canExecute = this.newName != null;
                return canExecute;
            }

            public boolean makesPlanRelatedChanges() {
                return true;
            }

            public void execute() {
                StandalonePlanEditorControllerExtension.this.abstractPlanAgent.setPlanElementNames(Collections.singletonMap(this.val$planElementUID, this.newName));
            }

            public boolean canUndoNow() {
                return true;
            }

            public void undo() {
                StandalonePlanEditorControllerExtension.this.abstractPlanAgent.setPlanElementNames(Collections.singletonMap(this.val$planElementUID, this.val$oldName));
            }

            public void redo() {
                this.execute();
            }
        });
    }

    public void changePlanElementDescriptionRequest(final IPlanAgentPlanElement planElement, IPlanEditorCommand editorCommand) {
        NameAndDescriptionAndCommentAndAspectID oldName = new NameAndDescriptionAndCommentAndAspectID(planElement.getPlanElementName(), planElement.getPlanElementDescription(), null, null);
        String planElementUID = planElement.getPlanElementUID();
        editorCommand.setMgrCommand(new IPlanEditorControllerCommand((INameAndDescriptionAndCommentAndAspectID)oldName, planElementUID){
            INameAndDescriptionAndCommentAndAspectID newName;
            private final /* synthetic */ INameAndDescriptionAndCommentAndAspectID val$oldName;
            private final /* synthetic */ String val$planElementUID;
            {
                this.val$oldName = iNameAndDescriptionAndCommentAndAspectID;
                this.val$planElementUID = string;
            }

            public boolean canExecuteInGeneral() {
                return true;
            }

            public boolean canExecuteNow() {
                Shell shell = StandalonePlanEditorControllerExtension.this.site.getShell();
                String newDescriptionString = DialogFacade.launchChangeNameDialog(shell, planElement.getPlanElementDescription());
                this.newName = newDescriptionString != null ? new NameAndDescriptionAndCommentAndAspectID(this.val$oldName.getName(), newDescriptionString, null, null) : null;
                boolean canExecute = this.newName != null;
                return canExecute;
            }

            public boolean makesPlanRelatedChanges() {
                return true;
            }

            public void execute() {
                StandalonePlanEditorControllerExtension.this.abstractPlanAgent.setPlanElementNames(Collections.singletonMap(this.val$planElementUID, this.newName));
            }

            public boolean canUndoNow() {
                return true;
            }

            public void undo() {
                StandalonePlanEditorControllerExtension.this.abstractPlanAgent.setPlanElementNames(Collections.singletonMap(this.val$planElementUID, this.val$oldName));
            }

            public void redo() {
                this.execute();
            }
        });
    }

    public void deletePlanElementsRequest(List<? extends IPlanAgentPlanElement> planElements, IPlanEditorCommand editorCommand) {
    }

    public Collection<MultipleObjectTransferContent> getNativeContentToAdd(List<? extends IPlanAgentPlanElement> planElements) {
        return Collections.emptyList();
    }

    public void doSaveTransaction(Runnable saveTransaction) {
        saveTransaction.run();
    }

    public void save(IProgressDisplay progressDisplay) {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public IEditorInput saveAsRequest() {
        SaveAsDialog dialog = new SaveAsDialog(this.site.getWorkbenchWindow().getShell());
        if (this.input instanceof IFileEditorInput) {
            dialog.setOriginalFile(((IFileEditorInput)this.input).getFile());
        }
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return this.input;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IFile file = workspace.getRoot().getFile(path);
        if (!file.exists()) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    try {
                        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
                        StandalonePlanEditorControllerExtension.this.input = (IPathEditorInput)new FileEditorInput(file);
                        ((StandalonePlanInfo)StandalonePlanEditorControllerExtension.this.abstractPlanAgent.getPlanInfo()).setInput(StandalonePlanEditorControllerExtension.this.input);
                        StandalonePlanEditorControllerExtension.this.abstractPlanAgent.planInfoChanged(StandalonePlanEditorControllerExtension.this.abstractPlanAgent.getPlanInfo());
                        StandalonePlanEditorControllerExtension.this.abstractPlanAgent.planFileLocationChanged(file.getLocation().toFile());
                        StandalonePlanEditorControllerExtension.this.abstractPlanAgent.savePlan(IProgressDisplay.DUMMY);
                        file.refreshLocal(1, null);
                    }
                    catch (Exception e) {
                        logger.error("Save as failed", (Throwable)e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.site.getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)op);
            }
            catch (Exception e) {
                logger.error("Save as failed", (Throwable)e);
            }
        }
        return this.input;
    }

    public void openPlanElement(IPlanAgentPlanElement planElement) {
    }

    public String getPlanElementTooltip(IPlanAgentPlanElement planElement) {
        return null;
    }

    public Image getDecorator(IPlanAgentPlanElement planElement) {
        return null;
    }

    public boolean isPlanElementTiedToUniqueElement(IPlanAgentPlanElement planElement) {
        return false;
    }

    public IContributionItem getObjectTypeCategoryContributionItem(List<IPlanAgentPlanElement> planElements) {
        return null;
    }
}

