/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.standalone;

import com.arcway.planagent.UpdatedAbstractPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.IAbstractPlanAgentController;
import com.arcway.planagent.controllinginterface.planagent.INameAndDescriptionAndCommentAndAspectID;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.planeditor.PlanEditorFacade;
import com.arcway.planagent.planeditor.standalone.StandalonePlanInfo;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class StandalonePlanEditorController
implements IAbstractPlanAgentController {
    private ResourceTracker resourceListener;

    public void setup(IPathEditorInput input, PlanEditorFacade editor, UpdatedAbstractPlanAgent abstractPlanAgent) {
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.resourceListener = new ResourceTracker(fileInput, editor, abstractPlanAgent);
            fileInput.getFile().getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
    }

    public void setAccessingMode(int newMode) throws EXWriteAccessDeniedException {
    }

    public void setPlanTypeID(String planTypeID) {
    }

    public void createPlanRequest(File planFile) throws EXWriteAccessDeniedException {
    }

    public INameAndDescriptionAndCommentAndAspectID getPlanElementName(IPlanAgentPlanElement planElement) {
        return null;
    }

    public void planStructureChanged() {
    }

    public void planFileChanged() throws EXWriteAccessDeniedException {
    }

    public void close() {
        if (this.resourceListener != null) {
            this.resourceListener.removeYourself();
        }
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private IFileEditorInput input;
        private final PlanEditorFacade editor;
        private final UpdatedAbstractPlanAgent abstractPlanAgent;

        public ResourceTracker(IFileEditorInput input, PlanEditorFacade editor, UpdatedAbstractPlanAgent abstractPlanAgent) {
            assert (input != null);
            assert (editor != null);
            this.input = input;
            this.editor = editor;
            this.abstractPlanAgent = abstractPlanAgent;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)this.input.getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                Display display = this.editor.getSite().getShell().getDisplay();
                if ((0x2000 & delta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ResourceTracker.this.editor.isDirty()) {
                                ResourceTracker.this.editor.getSite().getPage().closeEditor((IEditorPart)ResourceTracker.this.editor, false);
                            }
                        }
                    });
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResourceTracker.this.input = (IFileEditorInput)new FileEditorInput(newFile);
                            ((StandalonePlanInfo)ResourceTracker.this.abstractPlanAgent.getPlanInfo()).setInput((IPathEditorInput)((FileEditorInput)ResourceTracker.this.input));
                            ResourceTracker.this.abstractPlanAgent.planInfoChanged(ResourceTracker.this.abstractPlanAgent.getPlanInfo());
                            ResourceTracker.this.abstractPlanAgent.planFileLocationChanged(newFile.getLocation().toFile());
                            ResourceTracker.this.editor.setInput((IEditorInput)ResourceTracker.this.input);
                        }
                    });
                }
            } else if (delta.getKind() == 4 && !this.editor.isSaving()) {
                final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getFullPath());
                Display display = this.editor.getSite().getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ResourceTracker.this.input = (IFileEditorInput)new FileEditorInput(newFile);
                        ((StandalonePlanInfo)ResourceTracker.this.abstractPlanAgent.getPlanInfo()).setInput((IPathEditorInput)((FileEditorInput)ResourceTracker.this.input));
                        ResourceTracker.this.abstractPlanAgent.planInfoChanged(ResourceTracker.this.abstractPlanAgent.getPlanInfo());
                        ResourceTracker.this.editor.getCommandStack().flush();
                        try {
                            ResourceTracker.this.abstractPlanAgent.loadPlan(IProgressDisplay.DUMMY);
                        }
                        catch (EXSetupPlanException e) {
                            ResourceTracker.this.abstractPlanAgent.closePlan();
                        }
                    }
                });
            }
            return false;
        }

        public void removeYourself() {
            this.input.getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }
}

