/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.PlanEditorEditDomain;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.handles.IHandle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;

public abstract class AbstractHandle
implements IHandle {
    private static final ILogger logger = Logger.getLogger(AbstractHandle.class);
    private final EditPart editPart;
    private final FeedbackManager feedbackManager;
    protected int type;
    private final EditMgr viewManager;

    protected AbstractHandle(EditPart editPart, EditMgr viewManager, FeedbackManager feedbackManager, int type) {
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isTraceEnabled) {
            logger.trace("AbstractHandle(EditPart editPart = " + editPart + ", ViewMgr viewManager = " + viewManager + ", FeedbackManager feedbackManager = " + feedbackManager + ", int type = " + type + ") - start");
        }
        assert (editPart != null) : "editPart is null";
        assert (viewManager != null) : "viewManager is null";
        assert (feedbackManager != null) : "feedbackManager is null";
        this.editPart = editPart;
        this.viewManager = viewManager;
        this.feedbackManager = feedbackManager;
        this.type = type;
        if (isTraceEnabled) {
            logger.trace("AbstractHandle(EditPart, ViewMgr, FeedbackManager, int) - end");
        }
    }

    @Override
    public void showTargetFeedback(Request request) {
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isTraceEnabled) {
            logger.trace("showTargetFeedback(Request request = " + request + ") - start");
        }
        this.feedbackManager.showTargetFeedback(this.getCommand(request));
        if (isTraceEnabled) {
            logger.trace("showTargetFeedback(Request) - end");
        }
    }

    @Override
    public void eraseTargetFeedback(Request request) {
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isTraceEnabled) {
            logger.trace("eraseTargetFeedback(Request request = " + request + ") - start");
        }
        this.feedbackManager.eraseTargetFeedback();
        if (isTraceEnabled) {
            logger.trace("eraseTargetFeedback(Request) - end");
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    protected com.arcway.lib.geometry.Point transformToPlanCoordinates(Point pointToTransform) {
        assert (pointToTransform != null) : "pointToTransform is null";
        com.arcway.lib.geometry.Point point = new com.arcway.lib.geometry.Point((double)pointToTransform.x, (double)pointToTransform.y);
        com.arcway.lib.geometry.Point returnPoint = this.transformToPlanCoordinates(point);
        return returnPoint;
    }

    protected com.arcway.lib.geometry.Point transformToPlanCoordinates(com.arcway.lib.geometry.Point pointToTransform) {
        com.arcway.lib.geometry.Point returnPoint = this.viewManager.transformWindowToPlanCoordinates(pointToTransform, this.getEditPart().getRoot(), false);
        return returnPoint;
    }

    protected PlanEditorEditDomain getEditDomain() {
        return this.viewManager.getEditDomain();
    }

    protected EditPart getEditPart() {
        return this.editPart;
    }
}

