/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dnd;

import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.IDNDFileTransfer;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.planeditor.dnd.AbstractDNDListener;
import com.arcway.planagent.planeditor.dnd.DropDataAndListenerRequest;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.implementation.PlanElementModelWrapper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;

public class NativeFileDNDListener
extends AbstractDNDListener {
    private final IPlanEditorControllerExtension editorController;

    public NativeFileDNDListener(IPlanEditorControllerExtension editorController, EditPartViewer viewer) {
        super(viewer, (Transfer)FileTransfer.getInstance());
        assert (editorController != null);
        this.editorController = editorController;
    }

    public Request createTargetRequest() {
        DropDataAndListenerRequest returnRequest = new DropDataAndListenerRequest();
        return returnRequest;
    }

    protected void updateTargetRequest() {
    }

    @Override
    protected void handleDragOver() {
        int mode;
        EditPart ep = this.getTargetEditPart();
        IDNDFileTransfer data = null;
        DropTargetEvent event = this.getCurrentEvent();
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            final String[] files = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType);
            data = new IDNDFileTransfer(){

                public String[] getFiles() {
                    return files;
                }
            };
        }
        int modeWished = event.detail;
        int modesAllowed = event.operations;
        if (ep != null && ep instanceof PEPlanElement) {
            PEPlanElement pe = (PEPlanElement)ep;
            PlanElementModelWrapper wrapper = new PlanElementModelWrapper((IPMPlanElementRO)pe.getPMPlanElement());
            mode = this.editorController.isDropOnPlanElementAllowed((IPlanAgentPlanElement)wrapper, modesAllowed, modeWished, (Object)data);
        } else {
            mode = ep != null && ep instanceof PEPlan ? this.editorController.isDropOnPlanAllowed(modesAllowed, modeWished, (Object)data) : 0;
        }
        if ((modesAllowed & mode) == 0) {
            mode = 0;
        }
        this.getCurrentEvent().detail = mode;
        super.handleDragOver();
    }

    @Override
    protected void handleDrop() {
        this.updateTargetRequest();
        this.updateTargetEditPart();
        EditPart ep = this.getTargetEditPart();
        IDNDFileTransfer data = null;
        DropTargetEvent event = this.getCurrentEvent();
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            final String[] files = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType);
            data = new IDNDFileTransfer(){

                public String[] getFiles() {
                    return files;
                }
            };
        }
        int mode = event.detail;
        int modesAllowed = event.operations;
        if (data != null) {
            if (ep != null && ep instanceof PEPlanElement) {
                PEPlanElement pe = (PEPlanElement)ep;
                PlanElementModelWrapper wrapper = new PlanElementModelWrapper((IPMPlanElementRO)pe.getPMPlanElement());
                this.editorController.dropOnPlanElement((IPlanAgentPlanElement)wrapper, modesAllowed, mode, (Object)data);
            } else if (ep != null && ep instanceof PEPlan) {
                this.editorController.dropOnPlan(mode, (Object)data);
            } else {
                this.getCurrentEvent().detail = 0;
            }
        }
    }
}

