/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dnd;

import com.arcway.planagent.planeditor.commands.AbstractCommand;
import de.plans.lib.util.Logger;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public abstract class AbstractDNDListener
extends AbstractTransferDropTargetListener {
    private static final Logger logger = Logger.getLogger(AbstractDNDListener.class);

    public AbstractDNDListener(EditPartViewer viewer) {
        super(viewer);
    }

    public AbstractDNDListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    public void dragEnter(DropTargetEvent event) {
        super.dragEnter(event);
        if (!this.canExecute(this.getCommand())) {
            this.getCurrentEvent().detail = 0;
        }
    }

    protected void handleDragOperationChanged() {
        try {
            super.handleDragOperationChanged();
            if (!this.canExecute(this.getCommand())) {
                this.getCurrentEvent().detail = 0;
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Exception caught during handle drag operation changed: ", e);
            throw new RuntimeException(e);
        }
    }

    protected void handleDragOver() {
        try {
            super.handleDragOver();
            if (!this.canExecute(this.getCommand())) {
                this.getCurrentEvent().detail = 0;
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Exception caught during handle drag over: ", e);
            throw new RuntimeException(e);
        }
    }

    protected void handleDrop() {
        try {
            this.updateTargetRequest();
            this.updateTargetEditPart();
            if (this.getTargetEditPart() != null) {
                Command command = this.getCommand();
                if (!this.execute(command)) {
                    this.getCurrentEvent().detail = 0;
                } else {
                    this.getViewer().getControl().forceFocus();
                }
            } else {
                this.getCurrentEvent().detail = 0;
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Exception caught during handle drop: ", e);
            throw new RuntimeException(e);
        }
    }

    private boolean canExecute(Command command) {
        boolean canExecute = command == null ? false : command.canExecute();
        return canExecute;
    }

    private boolean execute(Command command) {
        boolean execute;
        if (command == null) {
            execute = false;
        } else {
            execute = command.canExecute();
            if (command instanceof AbstractCommand) {
                AbstractCommand abstractCommand = (AbstractCommand)command;
                execute &= abstractCommand.canExecuteNow();
            }
        }
        if (execute) {
            this.getViewer().getEditDomain().getCommandStack().execute(command);
        }
        return execute;
    }

    protected Command getCommand() {
        EditPart target = this.getTargetEditPart();
        Command command = target != null ? target.getCommand(this.getTargetRequest()) : null;
        return command;
    }
}

