/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.ImagePrinterPageDescription;
import com.arcway.lib.graphics.print.PreviewPrinter;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.dialogs.AbstractPreviewDialogSettings;
import com.arcway.planagent.planeditor.dialogs.DoublePattern;
import com.arcway.planagent.planeditor.dialogs.IPrinterCreator;
import com.arcway.planagent.planeditor.dialogs.InternalDialogSettings;
import com.arcway.planagent.planeditor.dialogs.PlotterHelpDialog;
import com.arcway.planagent.planeditor.dialogs.PrintPreviewCanvas;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planview.frameview.FrameViewConfig;
import com.arcway.planagent.planview.print.PageInfo;
import com.arcway.planagent.planview.print.PrintProcessor;
import com.arcway.planagent.planview.view.PVView;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import com.arcway.planagent.planview.viewcreator.ViewCreator;
import de.plans.lib.util.LocalisationUtils;
import java.text.ParseException;
import java.util.ArrayList;
import org.eclipse.draw2d.Cursors;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractPreviewDialog
extends TitleAreaDialog
implements IPrinterCreator,
PlotterHelpDialog.IPlanBoundsCalculator {
    protected static final double MIN_LEGEND_DISTANCE = 10.0;
    private static final int ITEM_PREVIEW = 0;
    private static final int ITEM_MARGIN_BOTTOM = 1;
    private static final int ITEM_MARGIN_RIGHT = 2;
    private static final int ITEM_MARGIN_LEFT = 3;
    private static final int ITEM_MARGIN_TOP = 4;
    private static final int ITEM_INNER_MARGINS = 7;
    protected static final int NR_OF_ABSTRACT_ITEMS = 8;
    private static final String ALIGNMENT_GROUP = Messages.getString("AbstractPreviewDialog.Alignment");
    private static final String ALIGN_HORIZONTAL = Messages.getString("AbstractPreviewDialog.Horizontal_alignment");
    private static final String ALIGN_VERTICAL = Messages.getString("AbstractPreviewDialog.Vertical_alignment");
    private static final String[] ALIGN_HORIZONTAL_LEVELS = new String[]{AbstractPreviewDialogSettings.getAlignmentString(1), AbstractPreviewDialogSettings.getAlignmentString(2), AbstractPreviewDialogSettings.getAlignmentString(4)};
    private static final String[] ALIGN_VERTICAL_LEVELS = new String[]{AbstractPreviewDialogSettings.getAlignmentString(8), AbstractPreviewDialogSettings.getAlignmentString(16), AbstractPreviewDialogSettings.getAlignmentString(32)};
    private static final int ALIGN_H = 0;
    private static final int ALIGN_V = 1;
    private static final String MARGIN_GROUP = Messages.getString("AbstractPreviewDialog.Margins");
    protected static final String MARGIN_AUTOMATICALLY = Messages.getString("AbstractPreviewDialog.Margin_Automatically");
    private static final String MARGIN_TOP = Messages.getString("AbstractPreviewDialog.Top_margin");
    private static final String MARGIN_LEFT = Messages.getString("AbstractPreviewDialog.Left_margin");
    private static final String MARGIN_RIGHT = Messages.getString("AbstractPreviewDialog.Right_margin");
    private static final String MARGIN_BOTTOM = Messages.getString("AbstractPreviewDialog.Bottom_margin");
    private static final String INNER_MARGINS = Messages.getString("AbstractPreviewDialog.InnerMargins");
    private static final String[] MARGIN_OPTIONS = new String[]{"0", "5", "10", "15", "20", "25", "30", "50", "70", "100"};
    private static final String MARGIN_MEASURE = "(mm)";
    private static final String CONTENT_GROUP = Messages.getString("AbstractPreviewDialog.Content");
    private static final String PROJECTIONS_TEXT = Messages.getString("AbstractPreviewDialog.IncludeProjections");
    private static final String HIGHLIGHTS_TEXT = Messages.getString("AbstractPreviewDialog.IncludeHighlights");
    private static final String COMMENTS_TEXT = Messages.getString("AbstractPreviewDialog.IncludeComments");
    private static final String INFORMATION_TEXT = Messages.getString("AbstractPreviewDialog.IncludeInformation");
    private static final String PREVIEW_TEXT = Messages.getString("AbstractPreviewDialog.Enable_Preview");
    protected static final int ERROR_LEVELS = 2;
    protected static final int ERROR_LEVEL_NON_PREVIEW = 0;
    protected static final int ERROR_LEVEL_PREVIEW = 1;
    private static final String MARGIN_UNPRINTABLE = String.valueOf(Messages.getString("AbstractPreviewDialog.is_not_within_printable_area")) + Messages.getString("AbstractPreviewDialog.It_is_possible_to_store_this_value,_but_your_print_may_be_cut");
    private static final String WARNING_MARGIN_TOP_UNPRINTABLE = String.valueOf(MARGIN_TOP) + MARGIN_UNPRINTABLE;
    private static final String WARNING_MARGIN_LEFT_UNPRINTABLE = String.valueOf(MARGIN_LEFT) + MARGIN_UNPRINTABLE;
    private static final String WARNING_MARGIN_RIGHT_UNPRINTABLE = String.valueOf(MARGIN_RIGHT) + MARGIN_UNPRINTABLE;
    private static final String WARNING_MARGIN_BOTTOM_UNPRINTABLE = String.valueOf(MARGIN_BOTTOM) + MARGIN_UNPRINTABLE;
    private Label labelVerticalAlignment;
    private Label labelHorizontalAlignment;
    private Combo comboHorizontalAlignment;
    private Combo comboVerticalAlignment;
    private Button toggleSetMarginsAutomatically;
    private Label labelMarginMeasure;
    private Label labelMarginTop;
    private Label labelMarginLeft;
    private Label labelMarginRight;
    private Label labelMarginBottom;
    private Combo comboMarginTop;
    private Combo comboMarginLeft;
    private Combo comboMarginRight;
    private Combo comboMarginBottom;
    private Label labelInnerMargins;
    private Combo comboInnerMargins;
    private Label labelInnerMarginsMeasure;
    private Button toggleProjectionsButton;
    private Button toggleHighlightsButton;
    private Button toggleInformationButton;
    private Button toggleCommentsButton;
    private PrintPreviewCanvas previewCanvas;
    private Button togglePreviewButton;
    private final DoublePattern marginPattern = new DoublePattern(0.0, 1000.0, false);
    private final IEditorContent editorContent;
    private PVView pVViewCache = null;
    private Rectangle pVBoundsCache = null;
    private Insets printerMarginsCache = null;
    private final InternalDialogSettings internalSettingsCopy;
    private final InternalDialogSettings internalSettings;
    protected String[][] errors;
    protected String[] warnings;

    public AbstractPreviewDialog(Shell parentShell, InternalDialogSettings internalSettings, IEditorContent editorContent) {
        super(parentShell);
        assert (internalSettings != null);
        assert (editorContent != null);
        this.editorContent = editorContent;
        this.internalSettingsCopy = new InternalDialogSettings(internalSettings);
        this.internalSettings = internalSettings;
    }

    protected abstract Group addCustomGroup(Composite var1);

    protected abstract Group addCustomBottomGroup(Composite var1);

    protected abstract String getExtendedErrorMessage(int var1);

    protected abstract AbstractPreviewDialogSettings getSettings();

    protected abstract String getStdMessage();

    protected abstract String getTitle();

    protected abstract boolean printerDefinesPrintingArea();

    protected boolean isAlignmentAreaToBeEnabled() {
        return !this.getSettings().isIncludeInformation();
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(this.getTitle());
        this.setTitle(this.getTitle());
        this.setMessage(this.getStdMessage());
        Composite globalArea = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        globalArea.setLayoutData((Object)gridData);
        globalArea.setLayout((Layout)gridLayout);
        Composite leftArea = new Composite(globalArea, 0);
        gridData = new GridData(770);
        leftArea.setLayoutData((Object)gridData);
        leftArea.setLayout((Layout)new GridLayout());
        Composite rightArea = new Composite(globalArea, 0);
        gridData = new GridData(1808);
        rightArea.setLayoutData((Object)gridData);
        rightArea.setLayout((Layout)new GridLayout());
        Group previewGroup = new Group(rightArea, 0);
        previewGroup.setText(Messages.getString("AbstractPreviewDialog.Preview"));
        gridData = new GridData(768);
        previewGroup.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        previewGroup.setLayout((Layout)gridLayout);
        this.previewCanvas = new PrintPreviewCanvas((Composite)previewGroup, 0);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 2;
        this.togglePreviewButton = new Button(rightArea, 32);
        this.togglePreviewButton.setText(PREVIEW_TEXT);
        this.togglePreviewButton.setSelection(this.internalSettingsCopy.getShowPreview());
        this.togglePreviewButton.setLayoutData((Object)gridData);
        this.addCustomGroup(leftArea);
        Group alignmentGroup = new Group(leftArea, 0);
        alignmentGroup.setText(ALIGNMENT_GROUP);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        alignmentGroup.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        alignmentGroup.setLayout((Layout)gridLayout);
        this.labelHorizontalAlignment = new Label((Composite)alignmentGroup, 16384);
        this.labelHorizontalAlignment.setText(ALIGN_HORIZONTAL);
        this.comboHorizontalAlignment = new Combo((Composite)alignmentGroup, 8);
        this.comboHorizontalAlignment.setItems(ALIGN_HORIZONTAL_LEVELS);
        this.setAlignmentCombo(this.comboHorizontalAlignment, this.getSettings().getPageSetup().getAlignment(), 0);
        gridData = new GridData(768);
        this.comboHorizontalAlignment.setLayoutData((Object)gridData);
        this.labelVerticalAlignment = new Label((Composite)alignmentGroup, 16384);
        this.labelVerticalAlignment.setText(ALIGN_VERTICAL);
        this.comboVerticalAlignment = new Combo((Composite)alignmentGroup, 8);
        this.comboVerticalAlignment.setItems(ALIGN_VERTICAL_LEVELS);
        this.setAlignmentCombo(this.comboVerticalAlignment, this.getSettings().getPageSetup().getAlignment(), 1);
        gridData = new GridData(768);
        this.comboVerticalAlignment.setLayoutData((Object)gridData);
        Group marginGroup = new Group(leftArea, 0);
        marginGroup.setText(MARGIN_GROUP);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        marginGroup.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        marginGroup.setLayout((Layout)gridLayout);
        if (this.printerDefinesPrintingArea()) {
            this.toggleSetMarginsAutomatically = new Button((Composite)marginGroup, 32);
            this.toggleSetMarginsAutomatically.setText(MARGIN_AUTOMATICALLY);
            this.toggleSetMarginsAutomatically.setSelection(this.getSettings().isSetMarginsAutomatically());
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            this.toggleSetMarginsAutomatically.setLayoutData((Object)gridData);
        } else {
            this.toggleSetMarginsAutomatically = null;
            this.getSettings().setSetMarginsAutomatically(false);
        }
        this.labelMarginTop = new Label((Composite)marginGroup, 16384);
        this.labelMarginTop.setText(MARGIN_TOP);
        this.comboMarginTop = new Combo((Composite)marginGroup, 4);
        this.comboMarginTop.setItems(MARGIN_OPTIONS);
        this.comboMarginTop.setText(LocalisationUtils.roundLocalized((double)this.getSettings().getPageSetup().getMargin().upperInset, (int)4, (boolean)true));
        this.comboMarginTop.setEnabled(!this.getSettings().isSetMarginsAutomatically());
        gridData = new GridData(768);
        this.comboMarginTop.setLayoutData((Object)gridData);
        this.labelMarginMeasure = new Label((Composite)marginGroup, 16384);
        this.labelMarginMeasure.setText(MARGIN_MEASURE);
        this.labelMarginLeft = new Label((Composite)marginGroup, 16384);
        this.labelMarginLeft.setText(MARGIN_LEFT);
        this.comboMarginLeft = new Combo((Composite)marginGroup, 4);
        this.comboMarginLeft.setItems(MARGIN_OPTIONS);
        this.comboMarginLeft.setText(LocalisationUtils.roundLocalized((double)this.getSettings().getPageSetup().getMargin().leftInset, (int)4, (boolean)true));
        this.comboMarginLeft.setEnabled(!this.getSettings().isSetMarginsAutomatically());
        gridData = new GridData(768);
        this.comboMarginLeft.setLayoutData((Object)gridData);
        this.labelMarginMeasure = new Label((Composite)marginGroup, 16384);
        this.labelMarginMeasure.setText(MARGIN_MEASURE);
        this.labelMarginRight = new Label((Composite)marginGroup, 16384);
        this.labelMarginRight.setText(MARGIN_RIGHT);
        this.comboMarginRight = new Combo((Composite)marginGroup, 4);
        this.comboMarginRight.setItems(MARGIN_OPTIONS);
        this.comboMarginRight.setText(LocalisationUtils.roundLocalized((double)this.getSettings().getPageSetup().getMargin().rightInset, (int)4, (boolean)true));
        this.comboMarginRight.setEnabled(!this.getSettings().isSetMarginsAutomatically());
        gridData = new GridData(768);
        this.comboMarginRight.setLayoutData((Object)gridData);
        this.labelMarginMeasure = new Label((Composite)marginGroup, 16384);
        this.labelMarginMeasure.setText(MARGIN_MEASURE);
        this.labelMarginBottom = new Label((Composite)marginGroup, 16384);
        this.labelMarginBottom.setText(MARGIN_BOTTOM);
        this.comboMarginBottom = new Combo((Composite)marginGroup, 4);
        this.comboMarginBottom.setItems(MARGIN_OPTIONS);
        this.comboMarginBottom.setText(LocalisationUtils.roundLocalized((double)this.getSettings().getPageSetup().getMargin().lowerInset, (int)4, (boolean)true));
        this.comboMarginBottom.setEnabled(!this.getSettings().isSetMarginsAutomatically());
        gridData = new GridData(768);
        this.comboMarginBottom.setLayoutData((Object)gridData);
        this.labelMarginMeasure = new Label((Composite)marginGroup, 16384);
        this.labelMarginMeasure.setText(MARGIN_MEASURE);
        Group innerMarginsComposite = marginGroup;
        this.labelInnerMargins = new Label((Composite)innerMarginsComposite, 16384);
        this.labelInnerMargins.setText(INNER_MARGINS);
        this.comboInnerMargins = new Combo((Composite)innerMarginsComposite, 4);
        this.comboInnerMargins.setItems(MARGIN_OPTIONS);
        this.comboInnerMargins.setText(LocalisationUtils.roundLocalized((double)this.getSettings().getInnerMarginsAsDouble(), (int)4, (boolean)true));
        this.comboInnerMargins.setEnabled(this.getSettings().isIncludeInformation());
        gridData = new GridData(768);
        this.comboInnerMargins.setLayoutData((Object)gridData);
        this.labelInnerMarginsMeasure = new Label((Composite)innerMarginsComposite, 16384);
        this.labelInnerMarginsMeasure.setText(MARGIN_MEASURE);
        Group contentGroup = new Group(globalArea, 0);
        contentGroup.setText(CONTENT_GROUP);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        contentGroup.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        contentGroup.setLayout((Layout)gridLayout);
        Group toggleInformationComposite = contentGroup;
        this.toggleInformationButton = new Button((Composite)toggleInformationComposite, 32);
        this.toggleInformationButton.setText(INFORMATION_TEXT);
        boolean forceMetainformation = this.isForcedMetainformation();
        this.getSettings().setIncludeInformation(forceMetainformation || this.getSettings().isIncludeInformation());
        this.toggleInformationButton.setSelection(this.getSettings().isIncludeInformation());
        this.toggleInformationButton.setEnabled(!forceMetainformation);
        gridData = new GridData();
        gridData.horizontalAlignment = 512;
        this.toggleInformationButton.setLayoutData((Object)gridData);
        this.toggleCommentsButton = new Button((Composite)contentGroup, 32);
        this.toggleCommentsButton.setText(COMMENTS_TEXT);
        this.toggleCommentsButton.setSelection(this.getSettings().isIncludeComments());
        this.toggleCommentsButton.setEnabled(this.containsComments(this.getEditorContent().getPlanModel()));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 512;
        this.toggleCommentsButton.setLayoutData((Object)gridData);
        this.toggleHighlightsButton = new Button((Composite)contentGroup, 32);
        this.toggleHighlightsButton.setText(HIGHLIGHTS_TEXT);
        this.toggleHighlightsButton.setSelection(this.getSettings().isIncludeHighlights());
        this.toggleHighlightsButton.setEnabled(this.hasBusinessHighlights(this.getEditorContent().getPlanModel()));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 512;
        this.toggleHighlightsButton.setLayoutData((Object)gridData);
        this.toggleProjectionsButton = new Button((Composite)contentGroup, 32);
        this.toggleProjectionsButton.setText(PROJECTIONS_TEXT);
        this.toggleProjectionsButton.setSelection(this.getSettings().isIncludeProjections());
        this.toggleProjectionsButton.setEnabled(!this.getEditorContent().getPlanModel().getProjections().isEmpty());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 512;
        this.toggleProjectionsButton.setLayoutData((Object)gridData);
        this.addCustomBottomGroup(globalArea);
        this.comboHorizontalAlignment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreviewDialog.this.refresh();
            }
        });
        this.comboVerticalAlignment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreviewDialog.this.refresh();
            }
        });
        this.comboMarginTop.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractPreviewDialog.this.comboMarginTop.isEnabled()) {
                    AbstractPreviewDialog.this.metainformationRelevantParemeterChanged();
                }
            }
        });
        this.comboMarginLeft.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractPreviewDialog.this.comboMarginLeft.isEnabled()) {
                    AbstractPreviewDialog.this.metainformationRelevantParemeterChanged();
                }
            }
        });
        this.comboMarginRight.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractPreviewDialog.this.comboMarginRight.isEnabled()) {
                    AbstractPreviewDialog.this.metainformationRelevantParemeterChanged();
                }
            }
        });
        this.comboMarginBottom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractPreviewDialog.this.comboMarginBottom.isEnabled()) {
                    AbstractPreviewDialog.this.metainformationRelevantParemeterChanged();
                }
            }
        });
        this.toggleProjectionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreviewDialog.this.modelOrViewCreationParameterChanged();
            }
        });
        this.toggleHighlightsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreviewDialog.this.modelOrViewCreationParameterChanged();
            }
        });
        this.toggleCommentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreviewDialog.this.modelOrViewCreationParameterChanged();
            }
        });
        this.toggleInformationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreviewDialog.this.modelOrViewCreationParameterChanged();
            }
        });
        this.comboInnerMargins.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractPreviewDialog.this.comboInnerMargins.isEnabled()) {
                    AbstractPreviewDialog.this.modelOrViewCreationParameterChanged();
                }
            }
        });
        if (this.toggleSetMarginsAutomatically != null) {
            this.toggleSetMarginsAutomatically.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractPreviewDialog.this.metainformationRelevantParemeterChanged();
                }
            });
        }
        this.togglePreviewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreviewDialog.this.updatePreview();
            }
        });
        return globalArea;
    }

    private boolean containsComments(IPMPlanRO plan) {
        boolean containsComments = false;
        int i = 0;
        while (i < plan.getPlanElementCount() && !containsComments) {
            containsComments |= plan.getPlanElementRO(i).isComment();
            ++i;
        }
        return containsComments;
    }

    private boolean isForcedMetainformation() {
        boolean forceMetainformation = true;
        IPlanInfo planInfo = this.editorContent.getPlanInfo();
        if (planInfo != null) {
            forceMetainformation = planInfo.getRestrictionClass() != IPlanInfo.RESTRICTIONS_NONE;
        }
        return forceMetainformation;
    }

    private boolean hasBusinessHighlights(IPMPlanRO plan) {
        boolean hasHighlights = false;
        int i = 0;
        while (!hasHighlights && i < plan.getPlanElementCount()) {
            hasHighlights |= plan.getPlanElementRO(i).getHighlight(HighlightLevel.BUSINESS) != null;
            ++i;
        }
        return hasHighlights;
    }

    public void create() {
        super.create();
        this.refresh();
    }

    private void updatePreview() {
        if (!this.togglePreviewButton.getSelection()) {
            this.previewCanvas.setNoImage();
        } else if (this.processErrorMessages() >= 1) {
            this.previewCanvas.setErrorImage();
        } else if (this.getSettings().getPageSetup().getPageCountX() * this.getSettings().getPageSetup().getPageCountY() <= 24) {
            Dimension paperSize = this.getCurrentPageSize();
            double paperWidthInMM = paperSize.width;
            double paperHeightInMM = paperSize.height;
            int pagesX = this.getSettings().getPageSetup().getPageCountX();
            int pagesY = this.getSettings().getPageSetup().getPageCountY();
            int windowWidthInPixel = 360;
            int windowHeightInPixel = 360;
            int paperDistanceInPixel = 4;
            int paperWidthInPixel = (int)Math.floor(((double)windowWidthInPixel - ((double)pagesX + 1.0) * (double)paperDistanceInPixel) / (double)pagesX);
            int paperHeightInPixel = (int)Math.floor(((double)windowHeightInPixel - ((double)pagesY + 1.0) * (double)paperDistanceInPixel) / (double)pagesY);
            paperWidthInPixel = this.limitPreviewPageWidth(paperWidthInPixel);
            paperHeightInPixel = this.limitPreviewPageHeight(paperHeightInPixel);
            double resX = (double)paperWidthInPixel / (paperWidthInMM / 25.4);
            double resY = (double)paperHeightInPixel / (paperHeightInMM / 25.4);
            double res = Math.min(resX, resY);
            PreviewPrinter previewPrinter = new PreviewPrinter(ImagePrinterPageDescription.createImageInfoInMM((double)paperWidthInMM, (double)paperHeightInMM, (Insets)this.getPrinterMargins(), (double)res, (double)res, (Color)Color.WHITE));
            PrintingFailure failure = this.print((IPrinter)previewPrinter);
            if (failure == null) {
                ArrayList images = new ArrayList(previewPrinter.getCreatedImages());
                this.previewCanvas.setRows(this.getSettings().getPageSetup().getPageCountY());
                this.previewCanvas.setImages(images);
            } else {
                this.previewCanvas.setPanicImage();
            }
        } else {
            this.previewCanvas.setDummyImage();
        }
    }

    protected Dimension getCurrentPageSize() {
        IPrinter printer = this.createPrinter();
        Dimension paperSize = printer.getPageSize().getDimension();
        this.disposePrinter(printer);
        return paperSize;
    }

    protected abstract int limitPreviewPageWidth(int var1);

    protected abstract int limitPreviewPageHeight(int var1);

    protected final void refresh() {
        this.readWidgetValues();
        this.updateSettings();
        this.writeWidgetValues();
        this.updatePreview();
    }

    protected void readWidgetValues() {
        this.getSettings().setIncludeProjections(this.toggleProjectionsButton.getSelection());
        this.getSettings().setIncludeComments(this.toggleCommentsButton.getSelection());
        this.getSettings().setIncludeHighlights(this.toggleHighlightsButton.getSelection());
        this.getSettings().setIncludeInformation(this.toggleInformationButton.getSelection());
        if (this.toggleSetMarginsAutomatically != null) {
            this.getSettings().setSetMarginsAutomatically(this.toggleSetMarginsAutomatically.getSelection());
        }
        int h = this.comboHorizontalAlignment.getSelectionIndex();
        switch (h) {
            case 0: {
                this.getSettings().getPageSetup().setHorizontalAlignment(1);
                break;
            }
            case 1: {
                this.getSettings().getPageSetup().setHorizontalAlignment(2);
                break;
            }
            case 2: {
                this.getSettings().getPageSetup().setHorizontalAlignment(4);
                break;
            }
        }
        int v = this.comboVerticalAlignment.getSelectionIndex();
        switch (v) {
            case 0: {
                this.getSettings().getPageSetup().setVerticalAlignment(8);
                break;
            }
            case 1: {
                this.getSettings().getPageSetup().setVerticalAlignment(16);
                break;
            }
            case 2: {
                this.getSettings().getPageSetup().setVerticalAlignment(32);
                break;
            }
        }
        this.removeErrors(4);
        this.removeErrors(3);
        this.removeErrors(2);
        this.removeErrors(1);
        this.removeErrors(7);
        Double marginTop = null;
        Double marginLeft = null;
        Double marginRight = null;
        Double marginBottom = null;
        Double innerMargins = null;
        if (this.toggleSetMarginsAutomatically == null || !this.toggleSetMarginsAutomatically.getSelection()) {
            if (!this.comboMarginLeft.isEnabled() && this.getSettings().isIncludeInformation()) {
                Insets symmetricPrinterMargins = this.getSymmetricPrintableArea();
                symmetricPrinterMargins = this.getExpandedPageMargins(symmetricPrinterMargins);
                this.setMarginWidgets(this.comboMarginTop, this.comboMarginLeft, this.comboMarginRight, this.comboMarginBottom, symmetricPrinterMargins);
            }
            marginTop = this.parseInput(this.comboMarginTop.getText(), this.marginPattern, 4);
            marginLeft = this.parseInput(this.comboMarginLeft.getText(), this.marginPattern, 3);
            marginRight = this.parseInput(this.comboMarginRight.getText(), this.marginPattern, 2);
            marginBottom = this.parseInput(this.comboMarginBottom.getText(), this.marginPattern, 1);
        } else {
            Insets symmetricPrinterMargins = this.getSymmetricPrintableArea();
            marginTop = new Double(symmetricPrinterMargins.upperInset);
            marginBottom = new Double(symmetricPrinterMargins.lowerInset);
            marginLeft = new Double(symmetricPrinterMargins.leftInset);
            marginRight = new Double(symmetricPrinterMargins.rightInset);
        }
        if (this.getSettings().isIncludeInformation()) {
            innerMargins = this.parseInput(this.comboInnerMargins.getText(), this.marginPattern, 7);
        }
        if (marginTop != null) {
            this.getSettings().getPageSetup().getMargin().upperInset = marginTop;
        }
        if (marginLeft != null) {
            this.getSettings().getPageSetup().getMargin().leftInset = marginLeft;
        }
        if (marginRight != null) {
            this.getSettings().getPageSetup().getMargin().rightInset = marginRight;
        }
        if (marginBottom != null) {
            this.getSettings().getPageSetup().getMargin().lowerInset = marginBottom;
        }
        if (innerMargins != null) {
            this.getSettings().setInnerMargins(innerMargins);
        }
    }

    private Insets getSymmetricPrintableArea() {
        Insets printerMargins = this.getPrinterMargins();
        double hor = Math.max(printerMargins.leftInset, printerMargins.rightInset);
        double ver = Math.max(printerMargins.upperInset, printerMargins.lowerInset);
        double both = Math.max(hor, ver);
        Insets symmetricPrinterMargins = new Insets(both);
        return symmetricPrinterMargins;
    }

    protected void updateSettings() {
        Insets printerMargins = this.getPrinterMargins();
        PageSetup currentPageSetup = this.getCurrentPageSetup();
        this.warnings[4] = currentPageSetup.getMargin().upperInset < printerMargins.upperInset - 1.0E-10 ? WARNING_MARGIN_TOP_UNPRINTABLE : null;
        this.warnings[3] = currentPageSetup.getMargin().leftInset < printerMargins.leftInset - 1.0E-10 ? WARNING_MARGIN_LEFT_UNPRINTABLE : null;
        this.warnings[2] = currentPageSetup.getMargin().rightInset < printerMargins.rightInset - 1.0E-10 ? WARNING_MARGIN_RIGHT_UNPRINTABLE : null;
        this.warnings[1] = currentPageSetup.getMargin().lowerInset < printerMargins.lowerInset - 1.0E-10 ? WARNING_MARGIN_BOTTOM_UNPRINTABLE : null;
        this.updatePageSetup();
        if (!this.isAlignmentAreaToBeEnabled()) {
            this.getSettings().getPageSetup().setAlignment(new Alignment(2, 16));
        }
    }

    protected void writeWidgetValues() {
        this.checkErrors(this.getSettings().getPageSetup().getMargin().upperInset, this.marginPattern, 4);
        this.checkErrors(this.getSettings().getPageSetup().getMargin().leftInset, this.marginPattern, 3);
        this.checkErrors(this.getSettings().getPageSetup().getMargin().rightInset, this.marginPattern, 2);
        this.checkErrors(this.getSettings().getPageSetup().getMargin().lowerInset, this.marginPattern, 1);
        this.comboHorizontalAlignment.setEnabled(this.isAlignmentAreaToBeEnabled());
        this.comboVerticalAlignment.setEnabled(this.isAlignmentAreaToBeEnabled());
        if (!this.comboHorizontalAlignment.isEnabled()) {
            this.setAlignmentCombo(this.comboHorizontalAlignment, this.getSettings().getPageSetup().getAlignment(), 0);
        }
        if (!this.comboVerticalAlignment.isEnabled()) {
            this.setAlignmentCombo(this.comboVerticalAlignment, this.getSettings().getPageSetup().getAlignment(), 1);
        }
        if (this.toggleSetMarginsAutomatically != null && this.toggleSetMarginsAutomatically.getSelection()) {
            this.comboMarginLeft.setEnabled(false);
            this.comboMarginRight.setEnabled(false);
            this.comboMarginTop.setEnabled(false);
            this.comboMarginBottom.setEnabled(false);
            this.setMarginWidgets(this.comboMarginTop, this.comboMarginLeft, this.comboMarginRight, this.comboMarginBottom, this.getSettings().getPageSetup().getMargin());
        } else {
            this.comboMarginLeft.setEnabled(true);
            this.comboMarginRight.setEnabled(true);
            this.comboMarginTop.setEnabled(true);
            this.comboMarginBottom.setEnabled(true);
        }
        this.comboInnerMargins.setEnabled(this.getSettings().isIncludeInformation());
        if (this.processErrorMessages() < 0) {
            this.processWarningMessages();
        }
    }

    private int processErrorMessages() {
        int error = -1;
        int j = 1;
        block0: while (j >= 0) {
            int i = this.errors.length - 1;
            while (i >= 0) {
                if (this.errors[i] != null && this.errors[i][j] != null) {
                    if (this.getButton(0) != null) {
                        this.enableOkButton(false);
                    }
                    this.setErrorMessage(this.errors[i][j]);
                    error = j;
                    break block0;
                }
                --i;
            }
            --j;
        }
        if (error < 0 && this.getButton(0) != null && !this.getButton(0).getEnabled()) {
            this.enableOkButton(true);
        }
        return error;
    }

    protected void enableOkButton(boolean enable) {
        this.getButton(0).setEnabled(enable);
    }

    protected void processWarningMessages() {
        boolean warning = false;
        this.setErrorMessage(null);
        int i = this.warnings.length - 1;
        while (i >= 0) {
            if (this.warnings[i] != null) {
                this.setMessage(this.warnings[i], 2);
                warning = true;
                break;
            }
            --i;
        }
        if (!warning) {
            this.setMessage(this.getStdMessage());
        }
    }

    protected void removeErrors(int item) {
        this.errors[item][1] = null;
    }

    protected Double parseInput(String text, DoublePattern pattern, int item) {
        Double returnValue = null;
        try {
            double parsedValue = LocalisationUtils.parseDoubleLocalized((String)text);
            if (pattern.isValue(parsedValue)) {
                returnValue = new Double(parsedValue);
            }
        }
        catch (ParseException e) {
            this.errors[item][1] = item >= 8 ? this.getExtendedErrorMessage(item) : this.getErrorMessage(item);
        }
        return returnValue;
    }

    protected void checkErrors(double value, DoublePattern pattern, int item) {
        if (this.errors[item][1] == null && !pattern.isValue(value)) {
            this.errors[item][1] = item >= 8 ? String.valueOf(this.getExtendedErrorMessage(item)) + " " + pattern.errorMessage(value) : String.valueOf(this.getErrorMessage(item)) + " " + pattern.errorMessage(value);
        }
    }

    private void setAlignmentCombo(Combo combo, Alignment alignment, int direction) {
        if (direction == 0) {
            switch (alignment.h) {
                case 1: {
                    combo.setText(ALIGN_HORIZONTAL_LEVELS[0]);
                    break;
                }
                case 2: {
                    combo.setText(ALIGN_HORIZONTAL_LEVELS[1]);
                    break;
                }
                case 4: {
                    combo.setText(ALIGN_HORIZONTAL_LEVELS[2]);
                }
            }
        } else if (direction == 1) {
            switch (alignment.v) {
                case 8: {
                    combo.setText(ALIGN_VERTICAL_LEVELS[0]);
                    break;
                }
                case 16: {
                    combo.setText(ALIGN_VERTICAL_LEVELS[1]);
                    break;
                }
                case 32: {
                    combo.setText(ALIGN_VERTICAL_LEVELS[2]);
                }
            }
        }
    }

    private void setMarginWidgets(Combo comboMarginTop, Combo comboMarginLeft, Combo comboMarginRight, Combo comboMarginBottom, Insets margins) {
        comboMarginTop.setText(LocalisationUtils.roundLocalized((double)(margins.upperInset + 0.005 + 1.0E-10), (int)2, (boolean)true));
        comboMarginLeft.setText(LocalisationUtils.roundLocalized((double)(margins.leftInset + 0.005 + 1.0E-10), (int)2, (boolean)true));
        comboMarginRight.setText(LocalisationUtils.roundLocalized((double)(margins.rightInset + 0.005 + 1.0E-10), (int)2, (boolean)true));
        comboMarginBottom.setText(LocalisationUtils.roundLocalized((double)(margins.lowerInset + 0.005 + 1.0E-10), (int)2, (boolean)true));
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.internalSettingsCopy.setShowPreview(this.togglePreviewButton.getSelection());
        this.internalSettings.copyFrom(this.internalSettingsCopy);
        super.okPressed();
    }

    private String getErrorMessage(int index) {
        String toReturn;
        switch (index) {
            case 0: {
                toReturn = Messages.getString("AbstractPreviewDialog.Preview_error");
                break;
            }
            case 1: {
                toReturn = Messages.getString("AbstractPreviewDialog.You_have_entered_an_invalid_value_for_the_bottom_margin");
                break;
            }
            case 2: {
                toReturn = Messages.getString("AbstractPreviewDialog.You_have_entered_an_invalid_value_for_the_right_margin");
                break;
            }
            case 3: {
                toReturn = Messages.getString("AbstractPreviewDialog.You_have_entered_an_invalid_value_for_the_left_margin");
                break;
            }
            case 4: {
                toReturn = Messages.getString("AbstractPreviewDialog.You_have_entered_an_invalid_value_for_the_top_margin");
                break;
            }
            default: {
                toReturn = Messages.getString("AbstractPreviewDialog.An_error_occurred._Please_check_your_settings_and_try_again");
            }
        }
        return toReturn;
    }

    protected final IEditorContent getEditorContent() {
        return this.editorContent;
    }

    private PVView getView() {
        if (this.pVViewCache == null) {
            ViewCreator creator = new ViewCreator();
            FrameViewConfig frameViewConfig = null;
            if (this.getSettings().isIncludeInformation()) {
                AbstractPreviewDialog printerCreator = this;
                IPrinter printer = printerCreator.createPrinter();
                boolean marginsAreOuterBorder = this.getSettings().isSetMarginsAutomatically();
                PageInfo pageInfo = new PageInfo(printer, this.getSettings().getPageSetup().getMargin(), marginsAreOuterBorder);
                printerCreator.disposePrinter(printer);
                frameViewConfig = this.getFrameViewConfig(pageInfo);
            }
            this.pVViewCache = creator.createPVView(this.editorContent, null, this.getSettings().isIncludeComments(), (HighlightLevel)(this.getSettings().isIncludeHighlights() ? HighlightLevel.BUSINESS : null), this.getSettings().isIncludeProjections(), frameViewConfig);
        }
        return this.pVViewCache;
    }

    protected final Rectangle getMinimalOuterBoundsInMM() {
        if (this.pVBoundsCache == null) {
            ViewCreator creator = new ViewCreator();
            FrameViewConfig frameViewConfig = null;
            if (this.getSettings().isIncludeInformation()) {
                frameViewConfig = FrameViewConfig.createFrame((Insets)this.getSettings().getInnerMargins(), (double)10.0, (double)1.0);
            }
            this.pVBoundsCache = creator.createPVView(this.editorContent, null, this.getSettings().isIncludeComments(), (HighlightLevel)(this.getSettings().isIncludeHighlights() ? HighlightLevel.BUSINESS : null), this.getSettings().isIncludeProjections(), frameViewConfig).getOuterBoundsWithoutChildren();
        }
        return this.pVBoundsCache;
    }

    @Override
    public double calculatePlanHeight(double planWidth) {
        Rectangle bounds;
        ViewCreator creator = new ViewCreator();
        FrameViewConfig frameViewConfig = null;
        if (this.getSettings().isIncludeInformation()) {
            frameViewConfig = FrameViewConfig.createFrameWithFixedWidth((double)planWidth, (boolean)true, (Insets)this.getSettings().getInnerMargins(), (double)10.0);
        }
        if ((bounds = creator.createPVView(this.editorContent, null, this.getSettings().isIncludeComments(), (HighlightLevel)(this.getSettings().isIncludeHighlights() ? HighlightLevel.BUSINESS : null), this.getSettings().isIncludeProjections(), frameViewConfig).getOuterBoundsWithoutChildren()) == null || bounds.w() < 1.0E-10) {
            return 0.0;
        }
        return bounds.h() * planWidth / bounds.w();
    }

    @Override
    public double calculatePlanWidth(double planHeight) {
        Rectangle bounds;
        ViewCreator creator = new ViewCreator();
        FrameViewConfig frameViewConfig = null;
        if (this.getSettings().isIncludeInformation()) {
            frameViewConfig = FrameViewConfig.createFrameWithFixedHeight((double)planHeight, (boolean)true, (Insets)this.getSettings().getInnerMargins(), (double)10.0);
        }
        if ((bounds = creator.createPVView(this.editorContent, null, this.getSettings().isIncludeComments(), (HighlightLevel)(this.getSettings().isIncludeHighlights() ? HighlightLevel.BUSINESS : null), this.getSettings().isIncludeProjections(), frameViewConfig).getOuterBoundsWithoutChildren()) == null || bounds.h() < 1.0E-10) {
            return 0.0;
        }
        return bounds.w() * planHeight / bounds.h();
    }

    @Override
    public Image createPreviewImage(Dimension paperSize, int pixelLimit) {
        double paperHeightInMM;
        double paperWidthInMM = paperSize.width;
        if (paperWidthInMM < 1.0E-10) {
            paperWidthInMM = 1.0;
        }
        if ((paperHeightInMM = paperSize.height) < 1.0E-10) {
            paperHeightInMM = 1.0;
        }
        int windowWidthInPixel = pixelLimit;
        int windowHeightInPixel = pixelLimit;
        int paperWidthInPixel = windowWidthInPixel;
        int paperHeightInPixel = windowHeightInPixel;
        double resX = (double)paperWidthInPixel / (paperWidthInMM / 25.4);
        double resY = (double)paperHeightInPixel / (paperHeightInMM / 25.4);
        double res = Math.min(resX, resY);
        PreviewPrinter previewPrinter = new PreviewPrinter(ImagePrinterPageDescription.createImageInfoInMM((double)paperWidthInMM, (double)paperHeightInMM, (Insets)this.getPrinterMargins(), (double)res, (double)res, (Color)Color.WHITE));
        PrintingFailure failure = this.printInternal((IPrinter)previewPrinter, this.createPreviewView(paperSize), new PageSetup(1, 1, this.getCurrentPageSetup().getAlignment(), 1.0, true, true, this.getCurrentPageSetup().getMargin()));
        Image image = null;
        if (failure == null) {
            ArrayList images = new ArrayList(previewPrinter.getCreatedImages());
            while (images.size() > 1) {
                ((Image)images.remove(1)).dispose();
            }
            if (images.size() > 0) {
                image = (Image)images.get(0);
            }
        }
        return image;
    }

    private PVView createPreviewView(Dimension planDimension) {
        ViewCreator creator = new ViewCreator();
        FrameViewConfig frameViewConfig = null;
        if (this.getSettings().isIncludeInformation()) {
            PageInfo pageInfo = new PageInfo(new Rectangle(0.0, 0.0, planDimension), new Insets(0.0), this.getSettings().getPageSetup().getMargin(), this.getSettings().isSetMarginsAutomatically());
            frameViewConfig = FrameViewConfig.createFrameWithFixedSizeExpandedToPageBorders((int)1, (int)1, (Insets)this.getSettings().getInnerMargins(), (double)10.0, (PageInfo)pageInfo);
        }
        PVView view = creator.createPVView(this.editorContent, null, this.getSettings().isIncludeComments(), (HighlightLevel)(this.getSettings().isIncludeHighlights() ? HighlightLevel.BUSINESS : null), this.getSettings().isIncludeProjections(), frameViewConfig);
        return view;
    }

    protected abstract FrameViewConfig getFrameViewConfig(PageInfo var1);

    private void flushPVViewCache() {
        this.pVViewCache = null;
        this.pVBoundsCache = null;
    }

    protected void modelOrViewCreationParameterChanged() {
        this.flushPVViewCache();
        this.refresh();
    }

    protected void metainformationRelevantParemeterChanged() {
        if (this.getSettings().isIncludeInformation()) {
            this.modelOrViewCreationParameterChanged();
        } else {
            this.refresh();
        }
    }

    private Insets getPrinterMargins() {
        if (this.printerMarginsCache == null) {
            IPrinter printer = this.createPrinter();
            Rectangle printRect = printer.getDrawingArea();
            Rectangle pageRect = printer.getPageSize();
            this.disposePrinter(printer);
            this.printerMarginsCache = new Insets(printRect.upperLeft.y - pageRect.upperLeft.y, pageRect.lowerRight.y - printRect.lowerRight.y, printRect.upperLeft.x - pageRect.upperLeft.x, pageRect.lowerRight.x - printRect.lowerRight.x);
        }
        return this.printerMarginsCache;
    }

    private void flushPrinterMarginsCache() {
        this.printerMarginsCache = null;
    }

    protected void printerChanged() {
        this.flushPrinterMarginsCache();
        this.flushPVViewCache();
        this.refresh();
    }

    protected void frameViewConfigChanged() {
        this.modelOrViewCreationParameterChanged();
    }

    protected final PrintingFailure print(IPrinter printer) {
        return this.printInternal(printer, this.getView(), this.getCurrentPageSetup());
    }

    private final PrintingFailure printInternal(IPrinter printer, PVView view, PageSetup pageSetup) {
        PrintingFailure failure = null;
        Shell shell = this.getShell();
        shell.setCursor(Cursors.WAIT);
        PrintProcessor pp = new PrintProcessor();
        try {
            pp.print(printer, view, pageSetup, this.getEditorContent().getPlanInfo().getPlanName());
        }
        catch (PrintingFailure f) {
            failure = f;
        }
        shell.setCursor(Cursors.ARROW);
        return failure;
    }

    private void updatePageSetup() {
        PageSetup currentPageSetup = this.getCurrentPageSetup();
        PrintProcessor pp = new PrintProcessor();
        IPrinter printer = this.createPrinter();
        pp.fillPrinterConfig(printer, this.getView(), currentPageSetup);
        this.disposePrinter(printer);
        currentPageSetup.setMargin(this.getSettings().getPageSetup().getMargin());
        this.getSettings().setPageSetup(new PageSetup(currentPageSetup));
    }

    private PageSetup getCurrentPageSetup() {
        PageSetup pageSetup = new PageSetup(this.getSettings().getPageSetup());
        boolean marginsAreOuterBorder = this.getSettings().isSetMarginsAutomatically();
        if (!marginsAreOuterBorder) {
            pageSetup.setMargin(this.getCroppedPageMargins(this.getSettings().getPageSetup().getMargin()));
        }
        return pageSetup;
    }

    private Insets getCroppedPageMargins(Insets insets) {
        insets = new Insets(insets);
        insets.upperInset -= 0.25;
        insets.leftInset -= 0.25;
        insets.rightInset -= 0.25;
        insets.lowerInset -= 0.25;
        return insets;
    }

    private Insets getExpandedPageMargins(Insets insets) {
        insets = new Insets(insets);
        insets.upperInset += 0.25;
        insets.leftInset += 0.25;
        insets.rightInset += 0.25;
        insets.lowerInset += 0.25;
        return insets;
    }
}

