/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;

public class PlanElementGeometryAnalysis {
    private boolean visited;
    private double minX = Double.POSITIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;

    static GeoVector getDistance(IPMPlanElementRO planElement, int alignment, double newPosition) {
        PlanElementGeometryAnalysis analysis = new PlanElementGeometryAnalysis();
        analysis.analyze(planElement);
        GeoVector distance = analysis.getDistance(alignment, newPosition);
        return distance;
    }

    public static double getBoundary(IPMPlanElementRO planElement, int alignment) {
        PlanElementGeometryAnalysis analysis = new PlanElementGeometryAnalysis();
        analysis.analyze(planElement);
        double boundary = analysis.getBoundary(alignment);
        return boundary;
    }

    private void analyze(IPMPlanElementRO planElement) {
        int i = 0;
        while (i < planElement.getFigureCount()) {
            IPMFigureRO figure = planElement.getFigureRO(i);
            IPMPointListRO pointList = figure.getPointListRO();
            int j = 0;
            while (j < pointList.getPointCount()) {
                IPMPointRO point = pointList.getPointRO(j);
                Point position = point.getPosition();
                this.minX = Math.min(this.minX, position.x);
                this.minY = Math.min(this.minY, position.y);
                this.maxX = Math.max(this.maxX, position.x);
                this.maxY = Math.max(this.maxY, position.y);
                this.visited = true;
                ++j;
            }
            ++i;
        }
    }

    private double getBoundary(int alignment) {
        double boundary;
        switch (alignment) {
            case 1: {
                boundary = this.getLeft();
                break;
            }
            case 2: {
                boundary = this.getHorizontalCenter();
                break;
            }
            case 4: {
                boundary = this.getRight();
                break;
            }
            case 8: {
                boundary = this.getUpper();
                break;
            }
            case 16: {
                boundary = this.getVerticalCenter();
                break;
            }
            case 32: {
                boundary = this.getLower();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return boundary;
    }

    private GeoVector getDistance(int alignment, double newPosition) {
        GeoVector distance;
        switch (alignment) {
            case 1: {
                distance = new GeoVector(newPosition - this.getLeft(), 0.0);
                break;
            }
            case 2: {
                distance = new GeoVector(newPosition - this.getHorizontalCenter(), 0.0);
                break;
            }
            case 4: {
                distance = new GeoVector(newPosition - this.getRight(), 0.0);
                break;
            }
            case 8: {
                distance = new GeoVector(0.0, newPosition - this.getUpper());
                break;
            }
            case 16: {
                distance = new GeoVector(0.0, newPosition - this.getVerticalCenter());
                break;
            }
            case 32: {
                distance = new GeoVector(0.0, newPosition - this.getLower());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return distance;
    }

    private double getLeft() {
        return this.visited ? this.minX : 0.0;
    }

    private double getHorizontalCenter() {
        return this.visited ? (this.minX + this.maxX) / 2.0 : 0.0;
    }

    private double getRight() {
        return this.visited ? this.maxX : 0.0;
    }

    private double getUpper() {
        return this.visited ? this.minY : 0.0;
    }

    private double getVerticalCenter() {
        return this.visited ? (this.minY + this.maxY) / 2.0 : 0.0;
    }

    private double getLower() {
        return this.visited ? this.maxY : 0.0;
    }
}

