/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.NamedColor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractColorDecoration
implements IAppearanceButtonDecorationWithMenu {
    @Override
    public ImageDescriptor getMenuEntryImage(Object state) {
        com.arcway.lib.graphics.Color color = (com.arcway.lib.graphics.Color)state;
        return this.getMenuEntryImage(color, 255);
    }

    public ImageDescriptor getMenuEntryImage(com.arcway.lib.graphics.Color color, int alpha) {
        int alphaBg;
        Color bc;
        Color fc;
        int w = 16;
        int h = 16;
        Image image = new Image((Device)Display.getCurrent(), w, h);
        GC g = new GC((Drawable)image);
        Color gray = new Color(null, 80, 80, 80);
        if (color != null && !color.transparent) {
            fc = new Color(null, color.r, color.g, color.b);
            bc = new Color(null, color.r, color.g, color.b);
            alphaBg = alpha;
        } else {
            fc = new Color(null, 80, 80, 80);
            bc = new Color(null, 200, 200, 200);
            alphaBg = 255;
        }
        g.setForeground(fc);
        g.setBackground(bc);
        if (alphaBg == 255) {
            this.drawMusterBg(g, 0, 0, w, h);
            this.drawMusterFg(g, 0, 0, w, h);
        } else {
            g.setForeground(gray);
            this.drawMusterFg(g, 0, 0, w, h);
            g.setAlpha(alphaBg);
            this.drawMusterBg(g, 0, 0, w, h);
            g.setAlpha(255);
            g.setForeground(fc);
        }
        this.drawMusterFrame(g, 0, 0, w, h);
        gray.dispose();
        fc.dispose();
        bc.dispose();
        g.dispose();
        final ImageData imageData = image.getImageData();
        image.dispose();
        ImageDescriptor desc = new ImageDescriptor(){

            public ImageData getImageData() {
                return imageData;
            }
        };
        return desc;
    }

    @Override
    public String getMenuEntryText(Object state) {
        com.arcway.lib.graphics.Color color = (com.arcway.lib.graphics.Color)state;
        String colorName = color != null && !color.transparent ? NamedColor.getNameForColor(color) : this.getUnfilledName();
        return colorName;
    }

    protected abstract String getUnfilledName();

    protected ImageDescriptor getCombiImage(com.arcway.lib.graphics.Color color, ImageDescriptor subImageDescriptor) {
        return this.getCombiImage(color, subImageDescriptor, 255);
    }

    protected ImageDescriptor getCombiImage(com.arcway.lib.graphics.Color color, ImageDescriptor subImageDescriptor, int alpha) {
        int alphaBg;
        Color bc;
        Color fc;
        ImageData subImageData = subImageDescriptor.getImageData();
        int w = subImageData.width;
        int h = subImageData.height;
        Image musterAsImage = new Image((Device)Display.getCurrent(), w, 4);
        GC g = new GC((Drawable)musterAsImage);
        Color gray = new Color(null, 80, 80, 80);
        if (color != null && !color.transparent) {
            fc = new Color(null, color.r, color.g, color.b);
            bc = new Color(null, color.r, color.g, color.b);
            alphaBg = alpha;
        } else {
            fc = new Color(null, 80, 80, 80);
            bc = new Color(null, 200, 200, 200);
            alphaBg = 255;
        }
        g.setForeground(fc);
        g.setBackground(bc);
        if (alphaBg == 255) {
            this.drawMusterBg(g, 0, 0, w, 4);
            this.drawMusterFg(g, 0, 0, w, 4);
        } else {
            g.setForeground(gray);
            this.drawMusterFg(g, 0, 0, w, 4);
            g.setAlpha(alphaBg);
            this.drawMusterBg(g, 0, 0, w, 4);
            g.setAlpha(255);
            g.setForeground(fc);
        }
        this.drawMusterFrame(g, 0, 0, w, 4);
        gray.dispose();
        fc.dispose();
        bc.dispose();
        g.dispose();
        Image combiImage = new Image(null, subImageData);
        g = new GC((Drawable)combiImage);
        g.drawImage(musterAsImage, 0, 0, w, 4, 0, h - 4, w, 4);
        g.dispose();
        final ImageData imageData = combiImage.getImageData();
        combiImage.dispose();
        musterAsImage.dispose();
        ImageDescriptor desc = new ImageDescriptor(){

            public ImageData getImageData() {
                return imageData;
            }
        };
        return desc;
    }

    private void drawMusterBg(GC gc, int x, int y, int w, int h) {
        gc.fillRectangle(x, y, w, h);
    }

    private void drawMusterFg(GC gc, int x, int y, int w, int h) {
        int x1 = x + 3;
        while (x1 <= x + w - 1) {
            gc.drawLine(x1, y, x1, y + h);
            x1 += 5;
        }
        int y1 = y + 3;
        while (y1 <= y + h - 1) {
            gc.drawLine(x, y1, x + w, y1);
            y1 += 5;
        }
    }

    private void drawMusterFrame(GC gc, int x, int y, int w, int h) {
        gc.drawRectangle(x, y, w - 1, h - 1);
    }
}

