/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.planagent.planeditor.FMCAPlanEditorCommonPlugin;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TextAppearanceTpl;
import de.plans.lib.eclipse.ResourceLoader;
import de.plans.lib.util.LocalisationUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;

public class TextSizeDecoration
implements IAppearanceButtonDecorationWithMenu {
    private static TextSizeDecoration singleton;
    private static ImageDescriptor image;

    static {
        image = ResourceLoader.getImageDescriptor((String)"cm/textsize.gif", (Plugin)FMCAPlanEditorCommonPlugin.getDefault());
    }

    private TextSizeDecoration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextSizeDecoration getInstance() {
        if (singleton != null) return singleton;
        Class<TextSizeDecoration> clazz = TextSizeDecoration.class;
        synchronized (TextSizeDecoration.class) {
            if (singleton != null) return singleton;
            singleton = new TextSizeDecoration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public Class[] getAppearanceClasses() {
        return new Class[]{ITextAppearanceRO.class};
    }

    public Object getStateOfAppearance(IAppearanceRO appearance) {
        return new Double(((ITextAppearanceRO)appearance).getTextLineHeight());
    }

    public String getToolTipText(Object state) {
        return this.getMenuEntryText(state);
    }

    public ImageDescriptor getButtonImageDescriptor(Object state) {
        return image;
    }

    public ImageDescriptor getMenuEntryImage(Object state) {
        return null;
    }

    public String getMenuEntryText(Object state) {
        double sizeM = (Double)state / 1000.0;
        String mm = LocalisationUtils.roundLocalized((double)(sizeM * 1000.0), (int)2, (boolean)false);
        String postscript = LocalisationUtils.roundLocalized((double)(sizeM * 2834.645669291339 * 0.8075987144168962), (int)1, (boolean)false);
        return String.valueOf(postscript) + " pt (" + mm + " mm)";
    }

    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        TextAppearanceTpl template = new TextAppearanceTpl();
        template.setTextHeight(((Double)state).doubleValue());
        return new IAppearanceTpl[]{template};
    }
}

