/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.MenuContributionItem;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import com.arcway.planagent.planeditor.cm.actions.TextAngleDecoration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class CITextAngle
extends MenuContributionItem {
    private static final String action_id_textangle_0 = "com.arcway.cockpitplanagent.editor.actions.textangle.1.0";
    private static final String action_id_textangle_30 = "com.arcway.cockpitplanagent.editor.actions.textangle.2.30";
    private static final String action_id_textangle_45 = "com.arcway.cockpitplanagent.editor.actions.textangle.3.45";
    private static final String action_id_textangle_60 = "com.arcway.cockpitplanagent.editor.actions.textangle.4.60";
    private static final String action_id_texangle_90 = "com.arcway.cockpitplanagent.editor.actions.textangle.5.90";
    private static final String postfixStringSeparator = ".separator";
    private static final Map<String, Integer> angleMaps = new HashMap<String, Integer>();
    private static ArrayList<String> sortedIDList;
    private static final IAppearanceButtonDecoration buttonType;
    public static final Integer initAngle;

    static {
        angleMaps.put(action_id_textangle_0, 0);
        angleMaps.put(action_id_textangle_30, 30);
        angleMaps.put(action_id_textangle_45, 45);
        angleMaps.put(action_id_textangle_60, 60);
        angleMaps.put(action_id_texangle_90, 90);
        sortedIDList = new ArrayList();
        Set<String> alignmentIDList = angleMaps.keySet();
        ArrayList<String> idList = new ArrayList<String>(alignmentIDList);
        Collections.sort(idList);
        sortedIDList = idList;
        buttonType = TextAngleDecoration.getInstance();
        initAngle = 0;
    }

    public CITextAngle() {
    }

    public CITextAngle(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected IAppearanceButtonDecoration getButtonType() {
        return buttonType;
    }

    private List<IContributionItem> constructContributionItem() {
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        AppearanceUtil.SelectionInfoProvider currentSelectionInfoOrNull = this.getCurrentSelectionInfoOrNull();
        boolean enabled = this.isActionEnabled(currentSelectionInfoOrNull, initAngle);
        ArrayList selectedStates = this.getSelectedStates(currentSelectionInfoOrNull);
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        for (String actionID : sortedIDList) {
            if (actionID.endsWith(postfixStringSeparator)) {
                items.add((IContributionItem)new Separator());
                continue;
            }
            Integer angle = angleMaps.get(actionID);
            String angleName = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryText((Object)angle);
            UIChangeAppearanceAction action = new UIChangeAppearanceAction(workbenchPage, actionID, angleName, (Object)angle, buttonType);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryImage((Object)angle);
            action.setImageDescriptor(imageDescriptor);
            action.setEnabled(enabled);
            boolean checked = false;
            if (enabled) {
                checked = CITextAngle.isActionChecked(angle, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        return items;
    }

    private static boolean isActionChecked(Integer angle, ArrayList<Object> selectedStates) {
        boolean checked = false;
        for (Object state : selectedStates) {
            Integer selectedAngle;
            if (state instanceof Integer && (checked = angle.equals(selectedAngle = (Integer)state))) break;
        }
        return checked;
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> items = this.constructContributionItem();
        IContributionItem[] colorItems = items.toArray(new IContributionItem[items.size()]);
        return colorItems;
    }
}

