/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.base.commands;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planeditor.base.Messages;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithNameSupplementRO;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithOutlineRO;
import com.arcway.planagent.planmodel.base.transactions.TACreateNameSupplement;
import com.arcway.planagent.planmodel.cm.persistent.EOGraphicalSupplementDataPlaneText;
import com.arcway.planagent.planmodel.transactions.Transaction;

public class CMCreateNameSupplement
extends TransactionCommand {
    private static final String COMMAND_LABEL = Messages.getString("CMCreateNameSupplement.Create_Name_Supplement");
    private static final ITextAppearanceRO TEXT_APPERANCE;
    private static final ILineAppearanceRO LINE_APPERANCE;
    private static final IFillAppearanceRO FILL_APPERANCE;

    static {
        EOGraphicalSupplementDataPlaneText dummy = new EOGraphicalSupplementDataPlaneText();
        TEXT_APPERANCE = dummy.getTextAppearance();
        LINE_APPERANCE = dummy.getLineAppearance();
        FILL_APPERANCE = dummy.getFillAppearance();
    }

    public CMCreateNameSupplement(IPMPlanElementWithNameSupplementRO planElement, Points geometry, ICommandContext commandContext) {
        super(commandContext);
        assert (planElement != null);
        Transaction transaction = CMCreateNameSupplement.createTransaction(planElement, geometry, this.getActionParameters());
        super.construct(COMMAND_LABEL, transaction);
    }

    public static Transaction createTransaction(IPMPlanElementWithNameSupplementRO planElement, Points geometry, ActionParameters actionParameters) {
        TACreateNameSupplement transaction;
        TextAppearance textAppearance = new TextAppearance(TEXT_APPERANCE);
        textAppearance.setAlignment(planElement.getDefaultAlignmentForNameSupplement());
        if (planElement.isNameSupplementWithLineAndFillAppearance()) {
            ILineAppearanceRO lineAppearance;
            if (planElement instanceof IPMPlanElementWithOutlineRO) {
                IPMPlanElementWithOutlineRO planElementWithOutline = (IPMPlanElementWithOutlineRO)planElement;
                lineAppearance = planElementWithOutline.getOutlineFigureRO().getLineAppearanceRO();
            } else {
                lineAppearance = LINE_APPERANCE;
            }
            transaction = new TACreateNameSupplement(planElement, actionParameters, TEXT_APPERANCE, lineAppearance, FILL_APPERANCE, geometry);
        } else {
            transaction = new TACreateNameSupplement(planElement, actionParameters, TEXT_APPERANCE, geometry);
        }
        return transaction;
    }
}

