/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.lib.projections;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;

public class WarningSignProjection
implements IProjection {
    private static final double CONVERSION_FACTOR = 0.2;
    private static final double rightX = 12.0;
    private static final double rightY = 10.4;
    private static final Color yellow = new Color(255, 255, 0);
    private static final Color darkGrey = new Color(10, 10, 10);
    private static final Color black = new Color(0, 0, 0);
    private static final FillStyle signFillStyle = FillStyle.SOLID;
    private static final FillColor signFillColor = new FillColor(yellow);
    private static final LineStyle signLineStyle = LineStyle.SOLID;
    private static final Color signLineColor = darkGrey;
    private static final double signLineThickness = 0.8;
    private static final double signRadius = 0.8;
    private static final FillStyle exclamationFillStyle = FillStyle.SOLID;
    private static final FillColor exclamationFillColor = new FillColor(black);
    private static final LineStyle exclamationLineStyle = LineStyle.SOLID;
    private static final Color exclamationLineColor = darkGrey;
    private static final double exclamationLineThickness = 0.2;
    private static Corners sign;
    private static Corners exclamation;
    private static Corners exclamationDot;

    public WarningSignProjection() {
        if (sign == null) {
            sign = new Corners();
            sign.add((Point)new Corner(6.0, 0.0, 0.8));
            sign.add((Point)new Corner(12.0, 10.4, 0.8));
            sign.add((Point)new Corner(0.0, 10.4, 0.8));
            exclamation = new Corners();
            exclamation.add((Point)new Corner(5.2, 3.6, 0.2));
            exclamation.add((Point)new Corner(6.800000000000001, 3.6, 0.2));
            exclamation.add((Point)new Corner(6.4, 7.6000000000000005, 0.0));
            exclamation.add((Point)new Corner(5.6000000000000005, 7.6000000000000005, 0.0));
            exclamationDot = new Corners();
            exclamationDot.add((Point)new Corner(5.4, 8.200000000000001));
            exclamationDot.add((Point)new Corner(6.6, 8.200000000000001));
            exclamationDot.add((Point)new Corner(6.6, 9.4));
            exclamationDot.add((Point)new Corner(5.4, 9.4));
        }
    }

    @Override
    public String getProjectionTypeID() {
        return "warningSign";
    }

    @Override
    public void drawProjection(Device device) {
        device.polygon(sign, signFillColor, signFillStyle, 0.8, signLineColor, signLineStyle);
        device.polygon(exclamation, exclamationFillColor, exclamationFillStyle, 0.2, exclamationLineColor, exclamationLineStyle);
        device.polygon(exclamationDot, exclamationFillColor, exclamationFillStyle, 0.2, exclamationLineColor, exclamationLineStyle);
    }

    @Override
    public Point getPosition(Rectangle area) {
        return new Point(area.lowerRight.x - 2.0, area.upperLeft.y - 5.0);
    }

    @Override
    public Rectangle getBoundary() {
        return new Rectangle(Math.floor(-0.4), Math.floor(-0.4), Math.ceil(12.4), Math.ceil(10.8));
    }
}

