/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.resource;

import com.arcway.lib.java.Assert;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.InputStream;

public class FileResourceInPackage
implements IStreamResource {
    private final Class<?> classFromPackageContainingResource;
    private final String packageRelativeResourceName;

    public FileResourceInPackage(Class<?> classFromPackageContainingResource, String packageRelativeResourceName) {
        Assert.checkArgumentBeeingNotNull(classFromPackageContainingResource);
        Assert.checkArgumentBeeingNotNull(packageRelativeResourceName);
        this.classFromPackageContainingResource = classFromPackageContainingResource;
        this.packageRelativeResourceName = packageRelativeResourceName;
    }

    public String getName() {
        return this.packageRelativeResourceName;
    }

    public InputStream toInputStream() throws JvmExternalResourceInteractionException {
        String packageName = this.classFromPackageContainingResource.getPackage().getName();
        String resourcePathName = String.valueOf(packageName.replace('.', '/')) + "/" + this.packageRelativeResourceName;
        InputStream inputStream = this.classFromPackageContainingResource.getClassLoader().getResourceAsStream(resourcePathName);
        Assert.checkArgumentBeeingNotNull(inputStream);
        return inputStream;
    }
}

