/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collections;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IListIterator_;
import com.arcway.lib.java.collections.IList_;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Collections_ {
    public static <T> IList_<T> singletonList(T o) {
        return new SingletonList_<T>(o);
    }

    private static class SingletonList_<E>
    implements IList_<E> {
        private final E singleElement;

        public SingletonList_(E o) {
            this.singleElement = o;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Collection<E> asJavaCollection() {
            return Collections.singletonList(this.singleElement);
        }

        @Override
        public E get(int index) {
            assert (Assert.checkArgument(index == 0));
            return this.singleElement;
        }

        @Override
        public List<E> asJavaList() {
            return Collections.singletonList(this.singleElement);
        }

        @Override
        public IListIterator_<E> iterator() {
            return new IListIterator_<E>(){
                private int position = -1;

                @Override
                public boolean hasNext() {
                    return this.position == -1;
                }

                @Override
                public E next() {
                    if (!$assertionsDisabled && this.position != -1) {
                        throw new AssertionError();
                    }
                    ++this.position;
                    return singleElement;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int index() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasPrev() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public E prev() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

