/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java;

import com.arcway.lib.java.IResource;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class ResourceTracker {
    private static final ILogger logger = Logger.getLogger(ResourceTracker.class);
    private static final Map<String, MaxCounter> className2ListsOfNewResources = new HashMap<String, MaxCounter>();
    private static final Map<String, MaxCounter> className2ListsOfInitializedResources = new HashMap<String, MaxCounter>();
    private static final Map<String, MaxCounter> className2ListsOfDisposedResources = new HashMap<String, MaxCounter>();
    private static final Map<String, MaxCounter> className2ListsOfFinalizedResources = new HashMap<String, MaxCounter>();
    private static WeakHashMap<ResourceWrapper, ResourceTracker> allNotYetGarbageCollectedResourceObjects = new WeakHashMap(10000, 0.5f);
    private final Exception creationTrace = new Exception(Long.toString(System.currentTimeMillis()));
    static final long MAX_INITIALIZATION_TRACES = 50L;
    private final List<Exception> initialisationTraces = new ArrayList<Exception>();
    long initialisationCount = 0L;
    static final long MAX_DISPOSE_TRACES = 50L;
    private final List<Exception> disposeTraces = new ArrayList<Exception>();
    long disposeCount = 0L;
    private final WeakHashMap<IResource, ResourceWrapper> indirectResourceWrapperReference;
    private final Class<? extends IResource> resourceClass;
    private ResourceTracker parentResourceTracker;

    public ResourceTracker(IResource resource) {
        this(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceTracker(IResource resource, ResourceTracker parentResourceTracker) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.parentResourceTracker = parentResourceTracker;
            ResourceWrapper resourceWrapper = new ResourceWrapper(System.identityHashCode(resource), this);
            this.indirectResourceWrapperReference = new WeakHashMap(2, 0.6f);
            this.indirectResourceWrapperReference.put(resource, resourceWrapper);
            this.resourceClass = resource.getClass();
            allNotYetGarbageCollectedResourceObjects.put(resourceWrapper, this);
            this.incCount(className2ListsOfNewResources);
            this.logEvent("RESOURCE CONSTRUCTED ");
        }
    }

    public void setParentResourceTracker(ResourceTracker parentResourceTracker) {
        this.parentResourceTracker = parentResourceTracker;
    }

    public void initialized() {
        ++this.initialisationCount;
        if (this.initialisationCount < 50L) {
            this.initialisationTraces.add(new Exception(Long.toString(System.currentTimeMillis())));
        } else {
            this.initialisationTraces.clear();
        }
        if (this.parentResourceTracker != null && this.parentResourceTracker.getNumberOfNonDisposedInitializations() <= 0L) {
            this.logError("Resource with not initialized parent was initialized.");
        }
        if (this.getNumberOfNonDisposedInitializations() > 1L) {
            this.logWarning("Undisposed resource was initialized again.");
        } else if (this.getNumberOfInitializations() > 1L) {
            this.logWarning("Disposed resource was initialized again.");
        }
        this.decCount(className2ListsOfNewResources);
        this.incCount(className2ListsOfInitializedResources);
        this.logEvent("RESOURCE INITIALIZED");
    }

    public void disposed() {
        ++this.disposeCount;
        if (this.disposeCount < 50L) {
            this.disposeTraces.add(new Exception(Long.toString(System.currentTimeMillis())));
        } else {
            this.disposeTraces.clear();
        }
        if (this.getNumberOfNonDisposedInitializations() < 0L) {
            this.logWarning("Resource was disposed more often than initialized.");
        }
        this.decCount(className2ListsOfInitializedResources);
        this.incCount(className2ListsOfDisposedResources);
        this.logEvent("RESOURCE DISPOSED   ");
    }

    protected void finalize() {
        if (this.getNumberOfInitializations() == 0L) {
            this.decCount(className2ListsOfNewResources);
        } else {
            this.decCount(className2ListsOfDisposedResources);
        }
        this.incCount(className2ListsOfFinalizedResources);
        if ((this.parentResourceTracker == null || this.parentResourceTracker.getNumberOfNonDisposedInitializations() > 0L) && this.getNumberOfNonDisposedInitializations() > 0L) {
            this.logError("Unreferenced resource was not disposed as often as initialized.");
        }
        this.logEvent("RESOURCE FINALIZED  ");
    }

    public long getNumberOfNonDisposedInitializations() {
        long numberOfInitialisations = this.getNumberOfInitializations();
        long numberOfDisposals = this.getNumberOfDisposals();
        return numberOfInitialisations - numberOfDisposals;
    }

    private long getNumberOfInitializations() {
        return this.initialisationCount;
    }

    private long getNumberOfDisposals() {
        return this.disposeCount;
    }

    private void logEvent(String event) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(event) + ": " + this.resourceClass.getName() + " (" + this.getCounter(className2ListsOfNewResources).toString() + ", " + this.getCounter(className2ListsOfInitializedResources).toString() + ", " + this.getCounter(className2ListsOfDisposedResources).toString() + ", " + this.getCounter(className2ListsOfFinalizedResources).toString() + ")");
        }
    }

    private void logError(String message) {
        this.log(String.valueOf(message) + "\nCreation stack trace:", this.creationTrace, true);
        this.logTraces(true);
    }

    private void logWarning(String message) {
        this.log(String.valueOf(message) + "\nCreation stack trace:", this.creationTrace, false);
        this.logTraces(false);
    }

    private void logTraces(boolean asError) {
        for (Exception e : this.initialisationTraces) {
            this.log("Resource Initialisation: ", e, asError);
        }
        for (Exception e : this.disposeTraces) {
            this.log("Resource Disposal: ", e, asError);
        }
    }

    private void log(String message, Exception e, boolean asError) {
        if (asError) {
            logger.error(String.valueOf(message) + " " + e.getMessage(), (Throwable)e);
        } else {
            logger.warn(String.valueOf(message) + " " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void incCount(Map<String, MaxCounter> map) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.getCounter(map).inc(this.getResource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void decCount(Map<String, MaxCounter> map) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.getCounter(map).dec(this.getResource());
        }
    }

    private MaxCounter getCounter(Map<String, MaxCounter> map) {
        String key = this.resourceClass.getName();
        MaxCounter counter = map.get(key);
        if (counter == null) {
            counter = new MaxCounter(key, map == className2ListsOfInitializedResources);
            map.put(key, counter);
        }
        return counter;
    }

    public Exception getCreationTrace() {
        return this.creationTrace;
    }

    public IResource getResource() {
        IResource result = null;
        try {
            result = this.indirectResourceWrapperReference.keySet().iterator().next();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return result;
    }

    public Class<? extends IResource> getResourceClass() {
        return this.resourceClass;
    }

    public static synchronized Collection<ResourceTracker> getResourceTrackersForAllNotYetGarbageCollectedResourceObjects() {
        int size = allNotYetGarbageCollectedResourceObjects.size();
        ArrayList<ResourceTracker> result = new ArrayList<ResourceTracker>(size);
        WeakHashMap<ResourceWrapper, ResourceTracker> newMap = new WeakHashMap<ResourceWrapper, ResourceTracker>(size * 4, 0.5f);
        int phantomEntries = 0;
        for (Map.Entry<ResourceWrapper, ResourceTracker> entry : allNotYetGarbageCollectedResourceObjects.entrySet()) {
            if (entry.getValue().getResource() != null) {
                newMap.put(entry.getKey(), entry.getValue());
                result.add(entry.getValue());
                continue;
            }
            ++phantomEntries;
        }
        allNotYetGarbageCollectedResourceObjects = newMap;
        return result;
    }

    private static class MaxCounter {
        private final String name;
        private int currentCount = 0;
        private int maxCount = 0;
        private final boolean log;

        private MaxCounter(String name, boolean log) {
            this.name = name;
            this.log = log;
        }

        private synchronized void inc(IResource relatedResource) {
            ++this.currentCount;
            this.updateMaxCount(relatedResource);
        }

        private synchronized void dec(IResource relatedResource) {
            --this.currentCount;
            this.updateMaxCount(relatedResource);
        }

        private void updateMaxCount(IResource relatedResource) {
            if (this.currentCount > this.maxCount) {
                this.maxCount = this.currentCount;
                if (this.log && this.maxCount > 1000 && this.maxCount % 100 == 0) {
                    relatedResource.getResourceTracker().logWarning("New Max-Count for resource " + this.name + ": " + this.maxCount + " Resource: " + relatedResource.hashCode());
                }
            }
        }

        public String toString() {
            return String.valueOf(this.currentCount) + "/" + this.maxCount;
        }
    }

    private static class ResourceWrapper {
        private final ResourceTracker tracker;
        private final int hashCode;

        public ResourceWrapper(int resourceHashCode, ResourceTracker tracker) {
            this.tracker = tracker;
            this.hashCode = resourceHashCode;
        }

        private IResource getResource() {
            return this.tracker.getResource();
        }

        public boolean equals(Object obj) {
            ResourceWrapper resourceWrapperObj;
            IResource objResource;
            if (obj == this) {
                return true;
            }
            return obj instanceof ResourceWrapper && (objResource = (resourceWrapperObj = (ResourceWrapper)obj).getResource()) != null && objResource == this.getResource();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

