/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.xml;

import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.IXMLDecodingHandler;
import com.arcway.lib.codec.xml.IXMLElementWO;
import com.arcway.lib.codec.xml.IXMLRootElementFactoryWO;
import com.arcway.lib.codec.xml.XMLAttribute;
import com.arcway.lib.codec.xml.XMLCharacters;
import com.arcway.lib.codec.xml.XMLElementName;
import com.arcway.lib.codec.xml.XMLProcessingInstruction;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;

public class XMLStackDecodingHandler
implements IXMLDecodingHandler {
    private final IXMLRootElementFactoryWO xmlRootElementFactory;
    private final IListRW_<XMLProcessingInstruction> rootProcessingInstructions = new ArrayList_<XMLProcessingInstruction>();
    private final IListRW_<IXMLElementWO> xmlElementStack = new ArrayList_<IXMLElementWO>();

    public XMLStackDecodingHandler(IXMLRootElementFactoryWO xmlRootElementFactory) {
        Assert.checkArgumentBeeingNotNull(xmlRootElementFactory);
        this.xmlRootElementFactory = xmlRootElementFactory;
    }

    @Override
    public void processingInstruction(XMLProcessingInstruction processingInstruction) throws EXXMLDecodingFailed {
        if (this.xmlElementStack.isEmpty()) {
            this.rootProcessingInstructions.add(processingInstruction);
        } else {
            this.finger().processingInstruction(processingInstruction);
        }
    }

    @Override
    public void startRootElement(XMLElementName elementName, IList_<XMLAttribute> attributes) throws EXXMLDecodingFailed {
        IXMLElementWO newElement = this.xmlRootElementFactory.createRootElement(this.rootProcessingInstructions, elementName, attributes);
        Assert.checkArgumentBeeingNotNull(newElement);
        this.push(newElement);
    }

    @Override
    public void startChildElement(XMLElementName elementName, IList_<XMLAttribute> attributes) throws EXXMLDecodingFailed {
        IXMLElementWO newElement = this.finger().createChildElement(elementName, attributes);
        Assert.checkArgumentBeeingNotNull(newElement);
        this.push(newElement);
    }

    @Override
    public void endElement() throws EXXMLDecodingFailed {
        this.pop().endElement();
    }

    @Override
    public void characters(XMLCharacters characters) throws EXXMLDecodingFailed {
        this.finger().characters(characters.getCharacters());
    }

    private void push(IXMLElementWO xmlElement) {
        this.xmlElementStack.add(xmlElement);
    }

    private IXMLElementWO finger() {
        return (IXMLElementWO)this.xmlElementStack.get(this.xmlElementStack.size() - 1);
    }

    private IXMLElementWO pop() {
        IXMLElementWO xmlElement = this.finger();
        Assert.checkState(this.xmlElementStack.size() > 0);
        this.xmlElementStack.remove(this.xmlElementStack.size() - 1);
        return xmlElement;
    }
}

