/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLDocumentFragmentScannerImpl;
import org.apache.xerces.impl.XMLDocumentScannerImpl;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDScanner;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLDocumentScannerImpl
extends XMLDocumentFragmentScannerImpl {
    protected static final int SCANNER_STATE_XML_DECL = 0;
    protected static final int SCANNER_STATE_PROLOG = 5;
    protected static final int SCANNER_STATE_TRAILING_MISC = 12;
    protected static final int SCANNER_STATE_DTD_INTERNAL_DECLS = 17;
    protected static final int SCANNER_STATE_DTD_EXTERNAL = 18;
    protected static final int SCANNER_STATE_DTD_EXTERNAL_DECLS = 19;
    protected static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String DTD_SCANNER = "http://apache.org/xml/properties/internal/dtd-scanner";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String NAMESPACE_CONTEXT = "http://apache.org/xml/properties/internal/namespace-context";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/nonvalidating/load-external-dtd", "http://apache.org/xml/features/disallow-doctype-decl"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/dtd-scanner", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/internal/namespace-context"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null};
    protected XMLDTDScanner fDTDScanner;
    protected ValidationManager fValidationManager;
    protected boolean fScanningDTD;
    protected String fDoctypeName;
    protected String fDoctypePublicId;
    protected String fDoctypeSystemId;
    protected NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected boolean fLoadExternalDTD = true;
    protected boolean fDisallowDoctype = false;
    protected boolean fSeenDoctypeDecl;
    protected XMLDocumentFragmentScannerImpl.Dispatcher fXMLDeclDispatcher = new XMLDeclDispatcher(this);
    protected XMLDocumentFragmentScannerImpl.Dispatcher fPrologDispatcher = new PrologDispatcher(this);
    protected XMLDocumentFragmentScannerImpl.Dispatcher fDTDDispatcher = new DTDDispatcher(this);
    protected XMLDocumentFragmentScannerImpl.Dispatcher fTrailingMiscDispatcher = new TrailingMiscDispatcher(this);
    private final String[] fStrings = new String[3];
    private final XMLString fString = new XMLString();
    private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLInputSource fExternalSubsetSource = null;
    private final XMLDTDDescription fDTDDescription = new XMLDTDDescription(null, null, null, null, null);

    public void setInputSource(XMLInputSource xMLInputSource) throws IOException {
        this.fEntityManager.setEntityHandler((XMLEntityHandler)this);
        this.fEntityManager.startDocumentEntity(xMLInputSource);
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        super.reset(xMLComponentManager);
        this.fDoctypeName = null;
        this.fDoctypePublicId = null;
        this.fDoctypeSystemId = null;
        this.fSeenDoctypeDecl = false;
        this.fScanningDTD = false;
        this.fExternalSubsetSource = null;
        if (!this.fParserSettings) {
            this.fNamespaceContext.reset();
            this.setScannerState(0);
            this.setDispatcher(this.fXMLDeclDispatcher);
            return;
        }
        try {
            this.fLoadExternalDTD = xMLComponentManager.getFeature(LOAD_EXTERNAL_DTD);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fLoadExternalDTD = true;
        }
        try {
            this.fDisallowDoctype = xMLComponentManager.getFeature(DISALLOW_DOCTYPE_DECL_FEATURE);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fDisallowDoctype = false;
        }
        this.fDTDScanner = (XMLDTDScanner)xMLComponentManager.getProperty(DTD_SCANNER);
        try {
            this.fValidationManager = (ValidationManager)xMLComponentManager.getProperty(VALIDATION_MANAGER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidationManager = null;
        }
        try {
            this.fNamespaceContext = (NamespaceContext)xMLComponentManager.getProperty(NAMESPACE_CONTEXT);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        if (this.fNamespaceContext == null) {
            this.fNamespaceContext = new NamespaceSupport();
        }
        this.fNamespaceContext.reset();
        this.setScannerState(0);
        this.setDispatcher(this.fXMLDeclDispatcher);
    }

    public String[] getRecognizedFeatures() {
        String[] stringArray = super.getRecognizedFeatures();
        int n = stringArray != null ? stringArray.length : 0;
        String[] stringArray2 = new String[n + RECOGNIZED_FEATURES.length];
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        System.arraycopy(RECOGNIZED_FEATURES, 0, stringArray2, n, RECOGNIZED_FEATURES.length);
        return stringArray2;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        super.setFeature(string, bl);
        if (string.startsWith("http://apache.org/xml/features/")) {
            int n = string.length() - "http://apache.org/xml/features/".length();
            if (n == "nonvalidating/load-external-dtd".length() && string.endsWith("nonvalidating/load-external-dtd")) {
                this.fLoadExternalDTD = bl;
                return;
            }
            if (n == "disallow-doctype-decl".length() && string.endsWith("disallow-doctype-decl")) {
                this.fDisallowDoctype = bl;
                return;
            }
        }
    }

    public String[] getRecognizedProperties() {
        String[] stringArray = super.getRecognizedProperties();
        int n = stringArray != null ? stringArray.length : 0;
        String[] stringArray2 = new String[n + RECOGNIZED_PROPERTIES.length];
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        System.arraycopy(RECOGNIZED_PROPERTIES, 0, stringArray2, n, RECOGNIZED_PROPERTIES.length);
        return stringArray2;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        super.setProperty(string, object);
        if (string.startsWith("http://apache.org/xml/properties/")) {
            int n = string.length() - "http://apache.org/xml/properties/".length();
            if (n == "internal/dtd-scanner".length() && string.endsWith("internal/dtd-scanner")) {
                this.fDTDScanner = (XMLDTDScanner)object;
            }
            if (n == "internal/namespace-context".length() && string.endsWith("internal/namespace-context") && object != null) {
                this.fNamespaceContext = (NamespaceContext)object;
            }
            return;
        }
    }

    public Boolean getFeatureDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[n].equals(string)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return super.getFeatureDefault(string);
    }

    public Object getPropertyDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[n].equals(string)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return super.getPropertyDefault(string);
    }

    public void startEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        super.startEntity(string, xMLResourceIdentifier, string2, augmentations);
        if (!string.equals("[xml]") && this.fEntityScanner.isExternal()) {
            this.setScannerState(16);
        }
        if (this.fDocumentHandler != null && string.equals("[xml]")) {
            this.fDocumentHandler.startDocument((XMLLocator)this.fEntityScanner, string2, this.fNamespaceContext, null);
        }
    }

    public void endEntity(String string, Augmentations augmentations) throws XNIException {
        super.endEntity(string, augmentations);
        if (this.fDocumentHandler != null && string.equals("[xml]")) {
            this.fDocumentHandler.endDocument(null);
        }
    }

    protected XMLDocumentFragmentScannerImpl.Dispatcher createContentDispatcher() {
        return new ContentDispatcher(this);
    }

    protected boolean scanDoctypeDecl() throws IOException, XNIException {
        if (!this.fEntityScanner.skipSpaces()) {
            this.reportFatalError("MSG_SPACE_REQUIRED_BEFORE_ROOT_ELEMENT_TYPE_IN_DOCTYPEDECL", null);
        }
        this.fDoctypeName = this.fEntityScanner.scanName();
        if (this.fDoctypeName == null) {
            this.reportFatalError("MSG_ROOT_ELEMENT_TYPE_REQUIRED", null);
        }
        if (this.fEntityScanner.skipSpaces()) {
            this.scanExternalID(this.fStrings, false);
            this.fDoctypeSystemId = this.fStrings[0];
            this.fDoctypePublicId = this.fStrings[1];
            this.fEntityScanner.skipSpaces();
        }
        boolean bl = this.fHasExternalDTD = this.fDoctypeSystemId != null;
        if (!this.fHasExternalDTD && this.fExternalSubsetResolver != null) {
            this.fDTDDescription.setValues(null, null, this.fEntityManager.getCurrentResourceIdentifier().getExpandedSystemId(), null);
            this.fDTDDescription.setRootName(this.fDoctypeName);
            this.fExternalSubsetSource = this.fExternalSubsetResolver.getExternalSubset((org.apache.xerces.xni.grammars.XMLDTDDescription)this.fDTDDescription);
            boolean bl2 = this.fHasExternalDTD = this.fExternalSubsetSource != null;
        }
        if (this.fDocumentHandler != null) {
            if (this.fExternalSubsetSource == null) {
                this.fDocumentHandler.doctypeDecl(this.fDoctypeName, this.fDoctypePublicId, this.fDoctypeSystemId, null);
            } else {
                this.fDocumentHandler.doctypeDecl(this.fDoctypeName, this.fExternalSubsetSource.getPublicId(), this.fExternalSubsetSource.getSystemId(), null);
            }
        }
        boolean bl3 = true;
        if (!this.fEntityScanner.skipChar(91)) {
            bl3 = false;
            this.fEntityScanner.skipSpaces();
            if (!this.fEntityScanner.skipChar(62)) {
                this.reportFatalError("DoctypedeclUnterminated", new Object[]{this.fDoctypeName});
            }
            --this.fMarkupDepth;
        }
        return bl3;
    }

    protected String getScannerStateName(int n) {
        switch (n) {
            case 0: {
                return "SCANNER_STATE_XML_DECL";
            }
            case 5: {
                return "SCANNER_STATE_PROLOG";
            }
            case 12: {
                return "SCANNER_STATE_TRAILING_MISC";
            }
            case 17: {
                return "SCANNER_STATE_DTD_INTERNAL_DECLS";
            }
            case 18: {
                return "SCANNER_STATE_DTD_EXTERNAL";
            }
            case 19: {
                return "SCANNER_STATE_DTD_EXTERNAL_DECLS";
            }
        }
        return super.getScannerStateName(n);
    }

    static /* synthetic */ XMLStringBuffer access$000(XMLDocumentScannerImpl xMLDocumentScannerImpl) {
        return xMLDocumentScannerImpl.fStringBuffer;
    }

    static /* synthetic */ XMLString access$100(XMLDocumentScannerImpl xMLDocumentScannerImpl) {
        return xMLDocumentScannerImpl.fString;
    }

    static /* synthetic */ XMLInputSource access$200(XMLDocumentScannerImpl xMLDocumentScannerImpl) {
        return xMLDocumentScannerImpl.fExternalSubsetSource;
    }

    static /* synthetic */ XMLInputSource access$202(XMLDocumentScannerImpl xMLDocumentScannerImpl, XMLInputSource xMLInputSource) {
        xMLDocumentScannerImpl.fExternalSubsetSource = xMLInputSource;
        return xMLDocumentScannerImpl.fExternalSubsetSource;
    }

    static /* synthetic */ XMLDTDDescription access$300(XMLDocumentScannerImpl xMLDocumentScannerImpl) {
        return xMLDocumentScannerImpl.fDTDDescription;
    }
}

