/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.model;

import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.List;

public class PermissionListModel {
    private final List<EOPermission> permissionsOnServer = new ArrayList<EOPermission>();
    private final List<EOPermission> addedPermissions = new ArrayList<EOPermission>();
    private final List<EOPermission> deletedPermissions = new ArrayList<EOPermission>();
    private String serverID;

    public void loadPermissionsFromServer(String serverID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        this.serverID = serverID;
        EOGenericMessage genericParameter = new EOGenericMessage();
        genericParameter.addAttribute("permissionSubSetUID", "SERVER");
        genericParameter.addAttribute("permissionSubSetType", "SERVER");
        EOClientRequest request = new EOClientRequest("permission", "getPermissionOfSubSet", (EncodableObjectBase)genericParameter);
        EOServerResponse response = PSCClientServiceFacade.getFacade().sendRequest(serverID, request);
        this.permissionsOnServer.clear();
        this.addedPermissions.clear();
        this.deletedPermissions.clear();
        if (response != null) {
            EOList list = (EOList)response.getResponseData();
            for (EncodableObjectBase element : list) {
                this.permissionsOnServer.add((EOPermission)element);
            }
        }
    }

    public void commitChanges() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest request = new EOClientRequest("permission", "addPermissions", (EncodableObjectBase)new EOList(this.addedPermissions));
        EOServerResponse response = PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
        request = new EOClientRequest("permission", "deletePermissions", (EncodableObjectBase)new EOList(this.deletedPermissions));
        response = PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
        this.loadPermissionsFromServer(this.serverID);
    }

    public void discardChanges() {
        this.addedPermissions.clear();
        this.deletedPermissions.clear();
    }

    public List<EOPermission> getPermissionsOfUser(String userName) {
        assert (userName != null) : "no username given";
        ArrayList<EOPermission> result = new ArrayList<EOPermission>();
        for (EOPermission p : this.permissionsOnServer) {
            if (!p.isOwnerTypeUser() || !userName.equals(p.getOwnerID()) || this.isDeleted(p)) continue;
            result.add(p);
        }
        for (EOPermission p : this.addedPermissions) {
            if (!p.isOwnerTypeUser() || !userName.equals(p.getOwnerID())) continue;
            result.add(p);
        }
        return result;
    }

    public List<EOPermission> getPermissionsOfGroup(String groupName) {
        assert (groupName != null) : "no groupName given";
        ArrayList<EOPermission> result = new ArrayList<EOPermission>();
        for (EOPermission p : this.permissionsOnServer) {
            if (!p.isOwnerTypeGroup() || !groupName.equals(p.getOwnerID()) || this.isDeleted(p)) continue;
            result.add(p);
        }
        for (EOPermission p : this.addedPermissions) {
            if (!p.isOwnerTypeGroup() || !groupName.equals(p.getOwnerID())) continue;
            result.add(p);
        }
        return result;
    }

    private boolean isDeleted(EOPermission permission) {
        for (EOPermission deletedPermission : this.deletedPermissions) {
            if (!deletedPermission.getPermissionUID().equals(permission.getPermissionUID())) continue;
            return true;
        }
        return false;
    }

    public void addPermission(EOPermission newPermission) {
        int i = this.deletedPermissions.size() - 1;
        while (i > -1) {
            EOPermission deletedPermission = this.deletedPermissions.get(i);
            if (deletedPermission.hasEqualRights(newPermission) && deletedPermission.getOwnerID().equals(newPermission.getOwnerID()) && deletedPermission.getOwnerType() == newPermission.getOwnerType()) {
                this.deletedPermissions.remove(i);
                return;
            }
            --i;
        }
        this.addedPermissions.add(newPermission);
    }

    public void deletePermission(EOPermission permission) {
        int i = this.addedPermissions.size() - 1;
        while (i > -1) {
            EOPermission addedPermission = this.addedPermissions.get(i);
            if (addedPermission.getPermissionUID().equals(permission.getPermissionUID())) {
                this.addedPermissions.remove(i);
                return;
            }
            --i;
        }
        this.deletedPermissions.add(permission);
    }
}

