/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin.swt;

import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.admin.CtrlAdminGroups;
import de.plans.psc.client.dialogs.admin.DlgAdminGroupsIF;
import de.plans.psc.client.dialogs.admin.swt.GroupListWrapper;
import de.plans.psc.client.dialogs.admin.swt.Messages;
import de.plans.psc.client.dialogs.admin.swt.PermissionListWrapper;
import de.plans.psc.client.dialogs.admin.swt.UIPnlGroupData;
import de.plans.psc.client.dialogs.admin.swt.UserListWrapper;
import de.plans.psc.client.dialogs.swt.IServerSelectionListener;
import de.plans.psc.client.dialogs.swt.UIPnlSelectServerDropList;
import de.plans.psc.client.model.GroupListModel;
import de.plans.psc.client.model.GroupWithUsers;
import de.plans.psc.client.model.PermissionListModel;
import de.plans.psc.client.model.User;
import de.plans.psc.client.model.UserGroup;
import de.plans.psc.client.model.UserListModel;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DlgAdminGroups
extends TitleAreaDialog
implements DlgAdminGroupsIF,
ISelectionChangedListener,
IServerSelectionListener {
    private CtrlAdminGroups ctrl;
    private GroupListWrapper groupListWrapper;
    private GroupListModel groupListModel;
    private PermissionListWrapper permissionListWrapper;
    private PermissionListModel permissionListModel;
    private UserListWrapper userListWrapper;
    private final UserListModel userListModel = new UserListModel();
    private Text fldFind;
    private Label lblFind;
    private UIPnlGroupData groupDetails;
    private UIPnlSelectServerDropList serverCombo;
    private Button btnEditGroupData;
    private Button btnEditUsers;
    private Button btnAddGroup;
    private Button btnDeleteGroup;
    private Button btnEditPermissions;
    private Button btnClose;
    private boolean isUserAdmin = false;
    private boolean selectGroup = false;
    private String serverID;
    GroupWithUsers selectedGroup;

    public DlgAdminGroups(Shell shell) {
        this(shell, null);
    }

    public DlgAdminGroups(Shell shell, String serverID) {
        super(shell);
        this.selectGroup = serverID != null;
        this.serverID = serverID;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Messages.getString("DlgAdminGroups.Group_Administration_1"));
        this.initComponents(composite);
        composite.pack();
        this.refreshDialog();
        return composite;
    }

    private void initComponents(Composite parent) {
        Group grpServers = new Group(parent, 0);
        grpServers.setText(Messages.getString("DlgAdminGroups.Available_Servers_2"));
        grpServers.setEnabled(!this.selectGroup);
        grpServers.setLayoutData((Object)new GridData(768));
        grpServers.setLayout((Layout)new GridLayout());
        this.serverCombo = new UIPnlSelectServerDropList((Composite)grpServers, this);
        this.serverCombo.setEnabled(!this.selectGroup);
        this.serverCombo.setLayoutData(new GridData(768));
        SashForm rootPanel = new SashForm(parent, 0);
        rootPanel.setLayoutData((Object)new GridData(1808));
        rootPanel.setLayout((Layout)new GridLayout(2, false));
        Composite leftPart = new Composite((Composite)rootPanel, 0);
        leftPart.setLayout((Layout)new GridLayout());
        leftPart.setLayoutData((Object)new GridData(1808));
        Composite findBase = new Composite(leftPart, 0);
        findBase.setLayoutData((Object)new GridData(768));
        findBase.setLayout((Layout)new GridLayout(2, false));
        this.lblFind = new Label(findBase, 0);
        this.lblFind.setText(Messages.getString("DlgAdminGroups.Find__3"));
        this.lblFind.setLayoutData((Object)new GridData());
        this.fldFind = new Text(findBase, 2048);
        this.fldFind.setLayoutData((Object)new GridData(768));
        this.fldFind.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DlgAdminGroups.this.fldFindKeyTyped();
            }
        });
        this.groupListWrapper = new GroupListWrapper(leftPart, 2562);
        this.groupListWrapper.getViewer().getList().setLayoutData((Object)new GridData(1808));
        this.groupListWrapper.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        Composite btnArea = new Composite(leftPart, 0);
        btnArea.setLayoutData((Object)new GridData(768));
        btnArea.setLayout((Layout)new GridLayout(2, true));
        this.btnAddGroup = new Button(btnArea, 8);
        this.btnAddGroup.setText(Messages.getString("DlgAdminGroups.Add_4"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnAddGroup.setLayoutData((Object)gridData);
        this.btnAddGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DlgAdminGroups.this.addGroup();
            }
        });
        this.btnDeleteGroup = new Button(btnArea, 8);
        this.btnDeleteGroup.setText(Messages.getString("DlgAdminGroups.Delete_5"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnDeleteGroup.setLayoutData((Object)gridData);
        this.btnDeleteGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DlgAdminGroups.this.deleteSelectedGroup();
            }
        });
        Composite rightPart = new Composite((Composite)rootPanel, 0);
        rightPart.setLayout((Layout)new GridLayout());
        rightPart.setLayoutData((Object)new GridData(1808));
        this.groupDetails = new UIPnlGroupData(rightPart, false);
        this.groupDetails.setLayoutData(new GridData(1808));
        this.btnEditGroupData = new Button(rightPart, 8);
        this.btnEditGroupData.setText(Messages.getString("DlgAdminGroups.Edit_6"));
        this.btnEditGroupData.setLayoutData((Object)new GridData(16384, -1, false, false));
        this.btnEditGroupData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DlgAdminGroups.this.editGroup();
            }
        });
        Group userListPanel = new Group(rightPart, 0);
        userListPanel.setText(Messages.getString("DlgAdminGroups.Users_7"));
        userListPanel.setLayoutData((Object)new GridData(1808));
        userListPanel.setLayout((Layout)new GridLayout());
        this.userListWrapper = new UserListWrapper((Composite)userListPanel, 2560);
        org.eclipse.swt.widgets.List list = this.userListWrapper.getViewer().getList();
        list.setLayoutData((Object)new GridData(1808));
        DlgAdminGroups.computeSizeOfList(list);
        this.btnEditUsers = new Button(rightPart, 8);
        this.btnEditUsers.setText(Messages.getString("DlgAdminGroups.Edit_8"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnEditUsers.setLayoutData((Object)new GridData(0x1000008, -1, false, false));
        this.btnEditUsers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DlgAdminGroups.this.editUsers();
            }
        });
        Group privListPanel = new Group(rightPart, 0);
        privListPanel.setText(Messages.getString("DlgAdminGroups.Basic_permissions_9"));
        privListPanel.setLayoutData((Object)new GridData(1808));
        privListPanel.setLayout((Layout)new GridLayout());
        this.permissionListWrapper = new PermissionListWrapper((Composite)privListPanel, 2560);
        list = this.permissionListWrapper.getViewer().getList();
        this.permissionListWrapper.getViewer().getList().setLayoutData((Object)new GridData(1808));
        DlgAdminGroups.computeSizeOfList(list);
        this.btnEditPermissions = new Button(rightPart, 8);
        this.btnEditPermissions.setText(Messages.getString("DlgAdminGroups.Edit_10"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnEditPermissions.setLayoutData((Object)new GridData(0x1000008, -1, false, false));
        this.btnEditPermissions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DlgAdminGroups.this.editPermissions();
            }
        });
    }

    private static void computeSizeOfList(org.eclipse.swt.widgets.List list) {
        int i = 0;
        while (i < 3) {
            list.add("");
            ++i;
        }
        int heigth = list.computeSize((int)-1, (int)-1).y;
        GridData gridData = (GridData)list.getLayoutData();
        gridData.heightHint = heigth;
        list.removeAll();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.setTitle(Messages.getString("DlgAdminGroups.Group_Administration_Dialog_11"));
        if (this.selectGroup) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        } else {
            this.btnClose = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
            this.getShell().setDefaultButton(this.btnClose);
        }
    }

    public void buttonPressed(int buttonID) {
        switch (buttonID) {
            case 0: 
            case 12: {
                this.close();
                break;
            }
            case 1: {
                this.selectedGroup = null;
                this.close();
                break;
            }
        }
    }

    @Override
    public void construct(CtrlAdminGroups control) {
        this.ctrl = control;
        if (this.serverCombo.size() == 1) {
            this.serverCombo.select(0);
            this.serverCombo.setEnabled(false);
        }
    }

    @Override
    public void construct(String p_serverID, GroupListModel groupList, boolean adminForGroups, PermissionListModel p_permissionListModel) {
        this.groupListModel = groupList;
        this.groupListWrapper.getViewer().setInput((Object)this.groupListModel);
        this.isUserAdmin = adminForGroups;
        this.permissionListModel = p_permissionListModel;
        this.serverID = p_serverID;
        this.refreshDialog();
    }

    @Override
    public void show() {
        this.open();
    }

    public GroupWithUsers getSelectedGroup() {
        return this.selectedGroup;
    }

    private void fldFindKeyTyped() {
        this.groupListWrapper.setFilter("*" + this.fldFind.getText().toLowerCase());
        this.groupListWrapper.setSelectionOnSingleDisplayedElement();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedGroup = (GroupWithUsers)this.groupListWrapper.getFirstSelectedGroup();
        this.updateDialog();
    }

    private void updateDialog() {
        if (this.selectedGroup != null) {
            this.groupDetails.setFields(this.selectedGroup);
            List<EOPermission> permissions = this.permissionListModel.getPermissionsOfGroup(this.selectedGroup.getGroupName());
            this.permissionListWrapper.setPermissions(permissions);
            List<User> users = this.selectedGroup.getUsers();
            this.userListModel.setUsers(users);
            this.userListWrapper.getViewer().setInput((Object)this.userListModel);
            this.refreshDialog();
        } else {
            this.groupDetails.clearFields();
            this.permissionListWrapper.setPermissions(new ArrayList());
            ArrayList users = new ArrayList();
            this.userListModel.setUsers(users);
            this.userListWrapper.getViewer().setInput((Object)this.userListModel);
            this.refreshDialog();
        }
    }

    private void refreshDialog() {
        if (this.serverID != null) {
            boolean isUserRealmWritable = this.ctrl.isUserRealmWritable();
            this.btnAddGroup.setEnabled(this.isUserAdmin && isUserRealmWritable);
            if (this.selectedGroup != null) {
                boolean ordinaryGroup = !this.selectedGroup.isSuperGroup();
                this.btnEditGroupData.setEnabled(this.isUserAdmin && isUserRealmWritable);
                this.btnEditUsers.setEnabled(this.isUserAdmin && isUserRealmWritable);
                this.btnEditPermissions.setEnabled(this.isUserAdmin);
                this.btnDeleteGroup.setEnabled(this.isUserAdmin && ordinaryGroup && isUserRealmWritable);
            } else {
                this.btnEditGroupData.setEnabled(false);
                this.btnEditUsers.setEnabled(false);
                this.btnEditPermissions.setEnabled(false);
                this.btnDeleteGroup.setEnabled(false);
            }
            this.groupListWrapper.getViewer().getList().setEnabled(true);
            this.permissionListWrapper.getViewer().getList().setEnabled(true);
            this.userListWrapper.getViewer().getList().setEnabled(true);
            this.fldFind.setEnabled(true);
        } else {
            this.btnAddGroup.setEnabled(false);
            this.btnEditGroupData.setEnabled(false);
            this.btnEditUsers.setEnabled(false);
            this.btnEditPermissions.setEnabled(false);
            this.btnDeleteGroup.setEnabled(false);
            this.groupListWrapper.getViewer().getList().setEnabled(false);
            this.permissionListWrapper.getViewer().getList().setEnabled(false);
            this.userListWrapper.getViewer().getList().setEnabled(false);
            this.fldFind.setEnabled(false);
        }
    }

    private void addGroup() {
        UserGroup newGroup = null;
        newGroup = this.ctrl.doAddGroup();
        this.groupListWrapper.getViewer().setInput((Object)this.groupListModel);
        if (newGroup != null) {
            this.groupListWrapper.getViewer().getList().setSelection(this.groupListModel.indexOf(newGroup));
            this.selectedGroup = (GroupWithUsers)newGroup;
            this.updateDialog();
        } else {
            this.groupDetails.clearFields();
            this.selectedGroup = null;
            this.updateDialog();
        }
    }

    private void deleteSelectedGroup() {
        if (this.selectedGroup != null && !this.selectedGroup.isSuperGroup()) {
            this.ctrl.doDeleteGroup(this.selectedGroup);
        }
        this.selectedGroup = null;
        this.groupListWrapper.getViewer().refresh();
        this.updateDialog();
    }

    private void editGroup() {
        UserGroup editedGroup = this.ctrl.doEditGroupData(this.selectedGroup);
        this.groupListWrapper.getViewer().setInput((Object)this.groupListModel);
        if (editedGroup != null) {
            this.groupListWrapper.getViewer().getList().setSelection(new String[]{this.groupListWrapper.getText(editedGroup)});
            this.selectedGroup = (GroupWithUsers)editedGroup;
            this.updateDialog();
        } else {
            this.groupDetails.clearFields();
            this.selectedGroup = null;
            this.updateDialog();
        }
    }

    private void editUsers() {
        this.ctrl.doAssignUsers(this.selectedGroup);
        this.userListModel.setUsers(this.selectedGroup.getUsers());
        this.userListWrapper.getViewer().setInput((Object)this.userListModel);
    }

    @Override
    public void serverSelected(ServerConnection serverConnection) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        this.ctrl.setServer(serverConnection);
    }

    private void editPermissions() {
        this.ctrl.doAssignPermissions(this.selectedGroup);
        this.updateDialog();
    }
}

