/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.PSCClientLicenseInfo;
import de.plans.psc.client.communication.IDataTransferRequestJob;
import de.plans.psc.client.communication.IRequestJob;
import de.plans.psc.client.communication.ISnoopRequestJob;
import de.plans.psc.client.communication.PSCAuthenticator;
import de.plans.psc.client.communication.transmissionprocessor.ControlAndUpdateEnquiryThread;
import de.plans.psc.client.communication.transmissionprocessor.StepAbstractStandardRequestJob;
import de.plans.psc.client.communication.transmissionprocessor.WorkloadTransmissionThread;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.PSCAbstractMessageDataFactory;
import java.io.File;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.List;

public class RequestTransmissionAndUpdateEnquiryProcessor {
    private final WorkloadTransmissionThread workloadTransmissionThread;
    private final ControlAndUpdateEnquiryThread controlAndUpdateEnquiryThread;

    public RequestTransmissionAndUpdateEnquiryProcessor(String serverName, URL serverURL, int timerInterval, PSCAbstractMessageDataFactory messageFactory, INotificationEnquiryResponseConsumer notificationConsumer) {
        this.controlAndUpdateEnquiryThread = new ControlAndUpdateEnquiryThread(this, serverName, serverURL, timerInterval, messageFactory, notificationConsumer);
        this.workloadTransmissionThread = new WorkloadTransmissionThread(serverName, messageFactory, this.controlAndUpdateEnquiryThread);
    }

    public void shutdownAndFreeResources() {
        this.workloadTransmissionThread.stopProcessor();
        this.controlAndUpdateEnquiryThread.stopProcessor();
    }

    public IRequestJob chargeLoginRequest(PSCApplicationIdentifier applicationIdentifier, PSCClientLicenseInfo clientLicenseSetting, PasswordAuthentication passwordAuthentication, PSCAuthenticator.RequestorInfo requestorInfo, String username, String password2) {
        return this.controlAndUpdateEnquiryThread.chargeLoginRequest(applicationIdentifier, clientLicenseSetting, passwordAuthentication, requestorInfo, username, password2);
    }

    public ISnoopRequestJob chargeSnoopRequest() {
        return this.controlAndUpdateEnquiryThread.chargeSnoopRequest();
    }

    public IRequestJob chargeDisconnectRequest() {
        return this.controlAndUpdateEnquiryThread.chargeDisconnectRequest();
    }

    public IRequestJob chargeRequest(EOClientRequest request) {
        return this.workloadTransmissionThread.chargeRequest(request);
    }

    StepAbstractStandardRequestJob chargeControlProcessorDelegatedRequestJob(EOClientRequest request) {
        assert (request.getReqSubID().equals("Fetch") || request.getReqSubID().equals("LoginPhase2"));
        return this.workloadTransmissionThread.chargeRequest(request);
    }

    public IDataTransferRequestJob chargeFileUploadRequest(List<String> transferIDs, List<File> files) {
        return this.workloadTransmissionThread.chargeFileUploadRequest(transferIDs, files);
    }

    public IDataTransferRequestJob chargeFileDownloadRequest(List<String> transferIDs, List<File> files) {
        return this.workloadTransmissionThread.chargeFileDownloadRequest(transferIDs, files);
    }

    public void updateServerURL(URL url) {
        this.controlAndUpdateEnquiryThread.updateServerURL(url);
    }

    public void setNotificationEnquiryInterval(long interval) {
        this.controlAndUpdateEnquiryThread.updateNotificationEnquiryInterval(interval);
    }

    public void stopNotificationEnquiry() {
        this.controlAndUpdateEnquiryThread.stopNotificationEnquiry();
    }

    public void startNotificationEnquiry() {
        this.controlAndUpdateEnquiryThread.startNotificationEnquiry();
    }

    public static interface INotificationEnquiryResponseConsumer {
        public void processNotificationEnquiryResponse(IRequestJob var1);
    }
}

