/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication;

import de.plans.psc.client.communication.Messages;
import de.plans.psc.shared.message.EOClientRequest;

public class ServerNotAvailableException
extends Exception {
    private final String serverID;
    private final EOClientRequest failedRequest;

    public ServerNotAvailableException(String serverID, EOClientRequest request) {
        super(Messages.getString("ServerNotAvailableException.Server_not_available._1"));
        assert (serverID != null);
        this.serverID = serverID;
        this.failedRequest = request;
    }

    public ServerNotAvailableException(String serverID, EOClientRequest request, String message, Throwable cause) {
        super(message);
        assert (serverID != null);
        this.serverID = serverID;
        this.failedRequest = request;
        if (cause != null) {
            this.initCause(cause);
        }
    }

    public EOClientRequest getUnprocessedRequest() {
        return this.failedRequest;
    }

    public String getServerID() {
        return this.serverID;
    }
}

