/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.psc.eclipse.client.update.xmlconstraints;

import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.IXMLElementWO;
import com.arcway.lib.codec.xml.XMLAttribute;
import com.arcway.lib.codec.xml.XMLAttributeName;
import com.arcway.lib.codec.xml.XMLElementName;
import com.arcway.lib.codec.xml.XMLProcessingInstruction;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.maps.IMap_;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.PluginVersionIdentifier;

public class VersionConstraint
implements IXMLElementWO {
    private static final HashSet<String> VALID_XML_ELEMENT_NAMES = new HashSet<String>(Arrays.asList("isCompatibleWith", "isEquivalentTo", "isGreaterOrEqualTo", "isGreaterThan", "isPerfect", "notIsCompatibleWith", "notIsEquivalentTo", "notIsGreaterOrEqualTo", "notIsGreaterThan", "notIsPerfect"));
    private static final XMLAttributeName VERSION_XMLAttributeName = new XMLAttributeName("version");
    private final String constraintType;
    private final PluginVersionIdentifier referenceVersion;

    public VersionConstraint(String fullConstraintType, IMap_<XMLAttributeName, XMLAttribute> attributes) throws EXXMLDecodingFailed {
        if (!VALID_XML_ELEMENT_NAMES.contains(fullConstraintType)) {
            throw new EXXMLDecodingFailed("Invalid ConstraintType Element detected: " + fullConstraintType);
        }
        this.constraintType = fullConstraintType;
        if (attributes == null || attributes.getByKey((Object)VERSION_XMLAttributeName) == null || ((XMLAttribute)attributes.getByKey((Object)VERSION_XMLAttributeName)).getAttributeValue().getRawStringValue() == null) {
            throw new EXXMLDecodingFailed("Invalid version attribute for " + this.constraintType + "detected.");
        }
        this.referenceVersion = new PluginVersionIdentifier(((XMLAttribute)attributes.getByKey((Object)VERSION_XMLAttributeName)).getAttributeValue().getRawStringValue());
    }

    public boolean isSatisfiedBy(PluginVersionIdentifier version) {
        String shortConstraintType;
        boolean negated;
        if (this.constraintType.startsWith("notI")) {
            negated = true;
            shortConstraintType = "i" + this.constraintType.substring(4);
        } else {
            negated = false;
            shortConstraintType = this.constraintType;
        }
        Boolean tmp = null;
        if ("isCompatibleWith".equals(shortConstraintType)) {
            tmp = version.isCompatibleWith(this.referenceVersion);
        } else if ("isEquivalentTo".equals(shortConstraintType)) {
            tmp = version.isEquivalentTo(this.referenceVersion);
        } else if ("isGreaterOrEqualTo".equals(shortConstraintType)) {
            tmp = version.isGreaterOrEqualTo(this.referenceVersion);
        } else if ("isGreaterThan".equals(shortConstraintType)) {
            tmp = version.isGreaterThan(this.referenceVersion);
        } else if ("isPerfect".equals(shortConstraintType)) {
            tmp = version.isPerfect(this.referenceVersion);
        }
        boolean result = tmp == null ? false : (negated ? !tmp.booleanValue() : tmp);
        return result;
    }

    public void characters(String characters) throws EXXMLDecodingFailed {
    }

    public IXMLElementWO createChildElement(XMLElementName elementName, IList_<XMLAttribute> attributes) throws EXXMLDecodingFailed {
        throw new EXXMLDecodingFailed("Unknown child Element for " + this.constraintType + " detected: " + elementName);
    }

    public void endElement() throws EXXMLDecodingFailed {
    }

    public void processingInstruction(XMLProcessingInstruction processingInstruction) throws EXXMLDecodingFailed {
    }
}

