/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.gui.elements;

import de.plans.lib.util.gui.elements.IUIElement;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class UIETextField
implements IUIElement {
    private Text text = null;
    private String description = null;
    private final IValueRangeHelperText valueRangeHelper;
    private final boolean multiLined;

    public UIETextField(String description, IValueRangeHelperText valueRangeHelper, boolean multiLined) {
        this.description = description;
        this.valueRangeHelper = valueRangeHelper;
        this.multiLined = multiLined;
    }

    public UIETextField(String description, IValueRangeHelperText valueRangeHelper) {
        this(description, valueRangeHelper, false);
    }

    @Override
    public Control getControl(Composite parent) {
        if (this.text == null || this.text.isDisposed()) {
            int style = this.multiLined ? 2626 : 2052;
            this.text = new Text(parent, style);
        }
        return this.text;
    }

    @Override
    public void getValue() {
        this.valueRangeHelper.setPersistentValue(this.text.getText().trim());
    }

    @Override
    public void setValue() {
        this.text.setText(this.valueRangeHelper.getDisplayFormat());
    }

    @Override
    public String checkCurrentValue() {
        if (this.valueRangeHelper.check(this.text.getText().trim())) {
            return null;
        }
        return this.valueRangeHelper.getErrorMessage(this.description);
    }

    @Override
    public void addModifyListener(ModifyListener listener) {
        this.text.addModifyListener(listener);
    }

    @Override
    public void removeModifyListener(ModifyListener listener) {
        this.text.removeModifyListener(listener);
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }

    public void forceText(String value) {
        this.text.setText(value);
    }

    public String getCurrentValue() {
        return this.text.getText();
    }
}

