/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.svg;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.Color;
import de.plans.lib.svg.EOSVGPath;
import de.plans.lib.svg.SVGAbstractConverter;
import de.plans.lib.svg.SVGConvertHelper;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class SVGArc
extends SVGAbstractConverter {
    private final Arc arc;
    private final Color arcColor;
    private final double arcWidth;

    public SVGArc(Arc arc, Color arcColor, double arcWidth) {
        assert (arc != null);
        assert (arcColor != null) : "arcColor = null";
        assert (arcWidth >= -1.0E-10) : "lineWidth < null";
        this.arc = arc;
        this.arcColor = arcColor;
        this.arcWidth = arcWidth;
    }

    @Override
    public void writeToXML(EncodableObjectBase.WriteContext writeContext, int indention) throws EXEncoderException {
        EOSVGPath svgPath = new EOSVGPath();
        Point startPoint = this.arc.getPointByAngle(this.arc.angleStart);
        Point endPoint = this.arc.getPointByAngle(this.arc.angleEnd);
        int clockDirection = this.arc.getDirection() ? 1 : 0;
        String dValue = "M " + startPoint.x + "," + startPoint.y + " A " + this.arc.rx + " " + this.arc.ry + " 0 0 " + clockDirection + " " + endPoint.x + "," + endPoint.y;
        svgPath.setDValue(dValue);
        svgPath.setPathColor(SVGConvertHelper.convertColorToSVGColor(this.arcColor));
        svgPath.setPathWidth(this.arcWidth);
        svgPath.setFillColor("none");
        svgPath.setLineCap("round");
        svgPath.writeXMLBody(writeContext, indention);
    }
}

