/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.resources.ResourceDisposer;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.eclipse.transfer.SerializableDataTypeTransferAgentWithFixDataType;
import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.eclipse.uiframework.widgets.dragndrop.IDropSupportingWidget;
import com.arcway.lib.eclipse.uiframework.widgets.dragndrop.SimpleWidgetDropListener;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.EnumerationItem;
import com.arcway.lib.ui.editor.IEnumerationItem_WithLabelAndIcon;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IRelationsListValueRange;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.RelationsListWidgetRelationWidgetAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class RelationsListWidget2
extends AbstractDataWidget
implements IDropSupportingWidget {
    public static final String TRANSFER_ID = "RelationsWidget";
    private Composite widgetComposite;
    private TableViewer tableViewer;
    private Text text;
    private Table table;
    private final LabelProvider labelProvider0 = new LabelProvider(0);
    private final LabelProvider labelProvider1 = new LabelProvider(1);
    private final ContentProvider contentProvider = new ContentProvider();
    private IRelationsListValueRange valueRange;
    private ISet_<Object> value;
    private List<EnumerationItem> changedValues;
    private final SerializableDataTypeTransferAgentWithFixDataType transferAgent;
    private static final Image image = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/delete2.png").createImage();
    private Cursor handCursor;
    private Cursor normalCursor;

    static {
        ResourceDisposer.markResourceAsSingleton((Resource)image);
    }

    public RelationsListWidget2(WidgetParameters widgetParameters, ICompositeWidget parentWidget, IDataWidgetAdapter adapter) {
        super(widgetParameters, adapter, (IEclipseCompositeWidget)parentWidget);
        assert (parentWidget instanceof IEclipseCompositeWidget);
        RelationsListWidgetRelationWidgetAdapter typedAdpater = (RelationsListWidgetRelationWidgetAdapter)this.getWidgetAdapter();
        IDataType dataType = typedAdpater.getObjectReferenceCollectionDataType();
        this.transferAgent = new SerializableDataTypeTransferAgentWithFixDataType(TRANSFER_ID, dataType);
        this.changedValues = new ArrayList<EnumerationItem>();
    }

    @Override
    public void createControl(Composite parentComposite) {
        this.widgetComposite = parentComposite;
        this.valueRange = (IRelationsListValueRange)this.getWidgetAdapter().getValueRange();
        this.value = (ISet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (this.isEditable() && isModificationPermitted && isModificationLocked) {
            this.getEditableControl(this.getFormToolkit());
        } else {
            this.getUneditableControl(this.getFormToolkit());
        }
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            Control[] childControls;
            FormToolkit toolkit = this.getFormToolkit();
            Control[] controlArray = childControls = this.widgetComposite.getChildren();
            int n = childControls.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.dispose();
                ++n2;
            }
            if (this.handCursor != null && !this.handCursor.isDisposed()) {
                this.handCursor.dispose();
            }
            if (this.normalCursor != null && !this.normalCursor.isDisposed()) {
                this.normalCursor.dispose();
            }
            this.valueRange = (IRelationsListValueRange)this.getWidgetAdapter().getValueRange();
            this.value = (ISet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
            boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
            if (this.isEditable() && isModificationPermitted && isModificationLocked) {
                this.getEditableControl(toolkit);
            } else {
                this.getUneditableControl(toolkit);
            }
            this.updateWidgetMessageDisplay();
            this.widgetComposite.pack();
        }
    }

    private String calculateRelationsStringrepresentation4TextControl() {
        StringBuilder val = new StringBuilder();
        boolean isFirst = true;
        for (IEnumerationItem_WithLabelAndIcon enumItem : this.valueRange.getValueRangeSubsetForSelectedRelations()) {
            if (!this.value.contains(enumItem.getKey())) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                val.append("\n");
            }
            val.append(enumItem.getLabel());
        }
        if (val.length() == 0) {
            val.append("-");
        }
        return val.toString();
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        if (this.tableViewer != null) {
            this.valueRange = (IRelationsListValueRange)this.getWidgetAdapter().getValueRange();
            this.value = (ISet_)this.getWidgetAdapter().getValue(mode);
            if (this.isEditable() || this.getWidgetAdapter().isModificationPermitted() || this.getWidgetAdapter().isModificationLocked()) {
                if (this.tableViewer != null) {
                    this.tableViewer.refresh();
                }
            } else if (this.text != null) {
                this.text.setText(this.calculateRelationsStringrepresentation4TextControl());
            }
        }
    }

    private Control getUneditableControl(FormToolkit toolkit) {
        if (this.normalCursor != null) {
            this.normalCursor.dispose();
        }
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
        toolkit.setBorderStyle(0);
        this.text = toolkit.createText(this.widgetComposite, this.calculateRelationsStringrepresentation4TextControl(), 74);
        TableWrapData uneditableControlTWD = new TableWrapData(256, 256);
        uneditableControlTWD.grabHorizontal = true;
        uneditableControlTWD.grabVertical = true;
        this.text.setLayoutData((Object)uneditableControlTWD);
        return this.text;
    }

    private Control getEditableControl(FormToolkit toolkit) {
        final Composite tableComposite = toolkit.createComposite(this.widgetComposite, 0);
        TableWrapData editableControlTWD = new TableWrapData(256, 256);
        editableControlTWD.grabHorizontal = true;
        editableControlTWD.grabVertical = true;
        tableComposite.setLayoutData((Object)editableControlTWD);
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 0;
        layout.horizontalSpacing = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.verticalSpacing = 0;
        tableComposite.setLayout((Layout)layout);
        toolkit.setBorderStyle(0);
        Text dragAndDropHintText = toolkit.createText(tableComposite, Messages.getString("RelationsListWidget.DragAndDropHint"), 74);
        TableWrapData dragAndDropHint = new TableWrapData(256, 256);
        dragAndDropHint.maxWidth = 200;
        dragAndDropHintText.setLayoutData((Object)dragAndDropHint);
        TableWrapData tableTD = new TableWrapData(256, 256);
        tableTD.heightHint = 100;
        tableTD.maxWidth = 200;
        tableTD.grabVertical = true;
        this.table = toolkit.createTable(tableComposite, 67586);
        this.table.setLayoutData((Object)tableTD);
        final TableColumn c0 = new TableColumn(this.table, 16384);
        final TableColumn c1 = new TableColumn(this.table, 131072);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        TableViewerColumn vc0 = new TableViewerColumn(this.tableViewer, c0);
        vc0.setLabelProvider((CellLabelProvider)this.labelProvider0);
        TableViewerColumn vc1 = new TableViewerColumn(this.tableViewer, c1);
        vc1.setLabelProvider((CellLabelProvider)this.labelProvider1);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setInput((Object)this);
        this.tableViewer.refresh();
        tableComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = tableComposite.getClientArea();
                Point preferredSize = RelationsListWidget2.this.table.computeSize(-1, -1);
                int width = area.width - 2 * RelationsListWidget2.this.table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = RelationsListWidget2.this.table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = RelationsListWidget2.this.table.getSize();
                if (oldSize.x > area.width) {
                    c0.setWidth(width - 20);
                    c1.setWidth(16);
                    RelationsListWidget2.this.table.setSize(area.width, area.height);
                } else {
                    RelationsListWidget2.this.table.setSize(area.width, area.height);
                    c0.setWidth(width - 20);
                    c1.setWidth(16);
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableItem item = RelationsListWidget2.this.table.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                if (item.getBounds(1).contains(e.x, e.y)) {
                    IEnumerationItem_WithLabelAndIcon enumerationItem = (IEnumerationItem_WithLabelAndIcon)item.getData();
                    RelationsListWidget2.this.changedValues.add(new EnumerationItem(enumerationItem.getKey(), null, null, false));
                    RelationsListWidget2.this.widgetModified();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TableItem item = RelationsListWidget2.this.table.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                if (item.getBounds(1).contains(e.x, e.y)) {
                    if (RelationsListWidget2.this.handCursor == null || RelationsListWidget2.this.handCursor.isDisposed()) {
                        RelationsListWidget2.this.handCursor = new Cursor((Device)Display.getDefault(), 21);
                    }
                    if (RelationsListWidget2.this.normalCursor != null) {
                        RelationsListWidget2.this.normalCursor.dispose();
                    }
                    RelationsListWidget2.this.table.setCursor(RelationsListWidget2.this.handCursor);
                } else {
                    if (RelationsListWidget2.this.handCursor != null) {
                        RelationsListWidget2.this.handCursor.dispose();
                    }
                    if (RelationsListWidget2.this.normalCursor == null || RelationsListWidget2.this.normalCursor.isDisposed()) {
                        RelationsListWidget2.this.normalCursor = new Cursor((Device)Display.getDefault(), 0);
                    }
                    RelationsListWidget2.this.table.setCursor(RelationsListWidget2.this.normalCursor);
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TableItem[] selectedItems;
                    TableItem[] tableItemArray = selectedItems = RelationsListWidget2.this.table.getSelection();
                    int n = selectedItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        IEnumerationItem_WithLabelAndIcon enumerationItem = (IEnumerationItem_WithLabelAndIcon)item.getData();
                        RelationsListWidget2.this.changedValues.add(new EnumerationItem(enumerationItem.getKey(), null, null, false));
                        ++n2;
                    }
                    RelationsListWidget2.this.widgetModified();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        SimpleWidgetDropListener.addDropListenerToControl(this, 4, 8, (Control)this.table);
        return tableComposite;
    }

    public Object getCurrentValue() {
        return this.changedValues;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private void widgetModified() {
        this.getWidgetAdapter().widgetModified();
        this.changedValues = new ArrayList<EnumerationItem>();
        this.updateWidget(IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE);
    }

    @Override
    public Transfer getTransferAgent() {
        return this.transferAgent;
    }

    @Override
    public boolean hasCorrectObjectType(Object contents) {
        ICollection_ typedContents = (ICollection_)contents;
        IIterator_ i = typedContents.iterator();
        while (i.hasNext()) {
            if (!this.isRelationPossible(i.next(), false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void performDrop(Object contents) {
        ICollection_ typedContents = (ICollection_)contents;
        for (Object key : typedContents) {
            if (!this.isRelationPossible(key, true)) continue;
            this.changedValues.add(new EnumerationItem(key, null, null, true));
        }
        this.widgetModified();
    }

    private boolean isRelationPossible(Object key, boolean checkPermissionAndAcquireLock) {
        RelationsListWidgetRelationWidgetAdapter typedAdapter = (RelationsListWidgetRelationWidgetAdapter)this.getWidgetAdapter();
        IEnumerationItem_WithLabelAndIcon enumItem = this.valueRange.getValueRangeItemForKey(key);
        if (enumItem != null) {
            if (!this.value.contains(key)) {
                boolean isRelationPossible = true;
                try {
                    isRelationPossible = typedAdapter.isRelationPossible(key, checkPermissionAndAcquireLock);
                }
                catch (EEXLockDenied eLD) {
                    isRelationPossible = false;
                    ITextProvider message = typedAdapter.getMessageForLockingException(eLD);
                    String localisedMessage = message.getText(PresentationContext.getVirtualMachineUserLocaleForNow());
                    MessageDialog.openInformation((Shell)this.widgetComposite.getShell(), (String)Messages.getString("RelationsListWidget2.RelationNotPossible.Title"), (String)NLS.bind((String)Messages.getString("RelationsListWidget2.RelationNotPossible.Message"), (Object)enumItem.getLabel(), (Object)localisedMessage));
                }
                return isRelationPossible;
            }
            return false;
        }
        return false;
    }

    @Override
    public Object getContentsFromTransferAgent(TransferData transferData) {
        return this.transferAgent.nativeToJava(transferData);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
        if (this.normalCursor != null) {
            this.normalCursor.dispose();
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement.equals(RelationsListWidget2.this) && RelationsListWidget2.this.value.size() > 0) {
                ArrayList<IEnumerationItem_WithLabelAndIcon> elements = new ArrayList<IEnumerationItem_WithLabelAndIcon>(RelationsListWidget2.this.value.size());
                for (IEnumerationItem_WithLabelAndIcon enumItem : RelationsListWidget2.this.valueRange.getValueRangeSubsetForSelectedRelations()) {
                    if (!RelationsListWidget2.this.value.contains(enumItem.getKey())) continue;
                    elements.add(enumItem);
                }
                return elements.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class LabelProvider
    extends ColumnLabelProvider {
        private final int columnIndex;

        public LabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getToolTipText(Object element) {
            if (this.columnIndex == 0) {
                if (element instanceof IEnumerationItem_WithLabelAndIcon) {
                    IEnumerationItem_WithLabelAndIcon enumItem = (IEnumerationItem_WithLabelAndIcon)element;
                    RelationsListWidgetRelationWidgetAdapter typedAdapter = (RelationsListWidgetRelationWidgetAdapter)RelationsListWidget2.this.getWidgetAdapter();
                    return typedAdapter.getHierarchyString(enumItem);
                }
            } else if (this.columnIndex == 1) {
                return Messages.getString("RelationsListWidget.delete", RelationsListWidget2.this.getContentLocale());
            }
            return null;
        }

        public String getText(Object element) {
            String text_ = null;
            if (this.columnIndex == 0) {
                if (element instanceof IEnumerationItem_WithLabelAndIcon) {
                    IEnumerationItem_WithLabelAndIcon item = (IEnumerationItem_WithLabelAndIcon)element;
                    text_ = item.getLabel();
                } else if (element instanceof String) {
                    text_ = (String)element;
                }
            }
            return text_;
        }

        public Image getImage(Object element) {
            if (this.columnIndex == 0) {
                IEnumerationItem_WithLabelAndIcon item;
                IStreamResource icon16x16AsStreamResource;
                if (element instanceof IEnumerationItem_WithLabelAndIcon && (icon16x16AsStreamResource = (item = (IEnumerationItem_WithLabelAndIcon)element).getIcon()) != null) {
                    return ImageCache.getImage(Display.getDefault(), icon16x16AsStreamResource);
                }
            } else {
                return image;
            }
            return null;
        }
    }
}

