/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import java.util.Locale;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class LocaleWidget
extends AbstractDataWidget
implements SelectionListener {
    private Control control;
    String[] isoLanguages = Locale.getISOLanguages();
    private Composite widgetComposite;

    public LocaleWidget(WidgetParameters parameters, ICompositeWidget parent, IDataWidgetAdapter adapter) {
        super(parameters, adapter, (IEclipseCompositeWidget)parent);
        assert (parent instanceof IEclipseCompositeWidget);
    }

    @Override
    public void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.widgetComposite = parentComposite;
        Locale value = (Locale)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
            this.createUneditableControl(toolkit, value);
        } else {
            this.createEditableControl(toolkit, value);
        }
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        if (mode != IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE) {
            Locale value = (Locale)this.getWidgetAdapter().getValue(mode);
            if (this.control != null) {
                String displayLanguage;
                String string = displayLanguage = value != null ? value.getDisplayLanguage(this.getContentLocale()) : "";
                if (!(this.isEditable() && this.getWidgetAdapter().isModificationPermitted() && this.getWidgetAdapter().isModificationLocked())) {
                    ((Text)this.control).setText(displayLanguage);
                } else {
                    ((CCombo)this.control).setText(displayLanguage);
                }
            }
        }
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            FormToolkit toolkit = this.getFormToolkit();
            this.control.dispose();
            Locale value = (Locale)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
            boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
            if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
                this.createUneditableControl(toolkit, value);
            } else {
                this.createEditableControl(toolkit, value);
            }
            this.updateWidgetMessageDisplay();
            this.widgetComposite.pack();
        }
    }

    public Object getCurrentValue() {
        Locale value = null;
        if (this.control != null) {
            value = !this.isEditable() || !this.getWidgetAdapter().isModificationPermitted() ? new Locale(((Text)this.control).getText()) : new Locale(((CCombo)this.control).getText());
        }
        return value;
    }

    public void setValue(Object value) {
        if (this.control != null) {
            if (!this.isEditable() || !this.getWidgetAdapter().isModificationPermitted()) {
                ((Text)this.control).setText(((Locale)value).getDisplayLanguage(this.getContentLocale()));
            } else {
                ((CCombo)this.control).setText(((Locale)value).getDisplayLanguage(this.getContentLocale()));
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.getWidgetAdapter().widgetModified();
    }

    private void createEditableControl(FormToolkit toolkit, Locale value) {
        toolkit.setBorderStyle(2048);
        this.control = new CCombo(this.widgetComposite, 0x800000);
        TableWrapData td = new TableWrapData(256);
        td.grabHorizontal = true;
        this.control.setLayoutData((Object)td);
        String[] stringArray = this.isoLanguages;
        int n = this.isoLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            ((CCombo)this.control).add(new Locale(element).getDisplayLanguage(this.getContentLocale()));
            ++n2;
        }
        if (value != null) {
            ((CCombo)this.control).setText(value.getDisplayLanguage(this.getContentLocale()));
        }
        ((CCombo)this.control).addSelectionListener((SelectionListener)this);
    }

    private void createUneditableControl(FormToolkit toolkit, Locale value) {
        toolkit.setBorderStyle(0);
        this.control = toolkit.createText(this.widgetComposite, value.getDisplayLanguage(this.getContentLocale()), 8);
        TableWrapData td = new TableWrapData(256);
        this.control.setLayoutData((Object)td);
    }
}

