/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.file.UrlLauncher;
import com.arcway.lib.eclipse.file.tmp.CheckOutTempFileProvider;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ResourceDisposer;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.eclipse.uiframework.widgets.dragndrop.IDropSupportingWidget;
import com.arcway.lib.eclipse.uiframework.widgets.dragndrop.SimpleWidgetDropListener;
import com.arcway.lib.io.AbstractFileWatcher;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.FileResourceWithOverwrittenName;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.IStreamResourceWithMetaInformation;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.parameters.FileWidgetParameters;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import java.io.File;
import java.text.DateFormat;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FileWidget
extends AbstractDataWidget
implements IDropSupportingWidget {
    private static final ILogger LOGGER = Logger.getLogger(FileWidget.class);
    private final boolean showName;
    private final boolean showAuthorAndDate;
    private final boolean isExternalEditingAllowed;
    private Composite widgetComposite;
    private Text text;
    private Label newLabelButton;
    private Label delLabelButton;
    private Label checkInOutLabelButton;
    private Label checkOutCancelLabelButton;
    private MouseListener checkInOutLabelButtonMouseListener;
    private final FileTransfer transferAgent = FileTransfer.getInstance();
    private boolean isEditableControl;
    private IStreamResource value;
    private static final Image NO_CROSS = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/nocross.png").createImage();
    private static final Image CROSS = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/cross.png").createImage();
    private static final Image FOLDER = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/folder.gif").createImage();
    private static final Image CHECK_OUT = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/pencil.png").createImage();
    private static final Image CHECK_OUT_CANCEL = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/pencil_stop.png").createImage();
    private static final Image CHECK_IN = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/pencil_ok.png").createImage();
    private File checkedOutFile;
    private File lastCheckedOutFile;
    private FileWatcher checkedOutWatcher;
    private Color checkOutColor;

    static {
        ResourceDisposer.markResourceAsSingleton((Resource)NO_CROSS);
        ResourceDisposer.markResourceAsSingleton((Resource)CROSS);
        ResourceDisposer.markResourceAsSingleton((Resource)FOLDER);
        ResourceDisposer.markResourceAsSingleton((Resource)CHECK_OUT);
        ResourceDisposer.markResourceAsSingleton((Resource)CHECK_OUT_CANCEL);
        ResourceDisposer.markResourceAsSingleton((Resource)CHECK_IN);
    }

    public FileWidget(WidgetParameters parameters, ICompositeWidget parent, IDataWidgetAdapter adapter) {
        super(parameters, adapter, (IEclipseCompositeWidget)parent);
        assert (parent instanceof IEclipseCompositeWidget);
        if (parameters instanceof FileWidgetParameters) {
            FileWidgetParameters fileWidgetParameters = (FileWidgetParameters)parameters;
            this.showName = fileWidgetParameters.getMode() == FileWidgetParameters.Mode.SHOW_ALL || fileWidgetParameters.getMode() == FileWidgetParameters.Mode.SHOW_NAME_ONLY;
            this.showAuthorAndDate = fileWidgetParameters.getMode() == FileWidgetParameters.Mode.SHOW_ALL || fileWidgetParameters.getMode() == FileWidgetParameters.Mode.SHOW_AUTHOR_AND_DATE_ONLY;
            this.isExternalEditingAllowed = fileWidgetParameters.isExternalEditingAllowed();
        } else {
            this.showName = true;
            this.showAuthorAndDate = true;
            this.isExternalEditingAllowed = true;
        }
    }

    @Override
    public void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.widgetComposite = toolkit.createComposite(parentComposite);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.numColumns = 5;
        this.widgetComposite.setLayout((Layout)layout);
        TableWrapData td = new TableWrapData(256);
        td.grabHorizontal = true;
        this.widgetComposite.setLayoutData((Object)td);
        this.checkOutColor = this.widgetComposite.getDisplay().getSystemColor(7);
        this.createControl_internal(toolkit);
        this.setValueInWidget(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
    }

    @Override
    protected void createWidgetMessageDisplayControl(Control controlAtWhichToDisplayMessages) {
        super.createWidgetMessageDisplayControl((Control)this.widgetComposite);
    }

    private void createControl_internal(FormToolkit toolkit) {
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
            this.isEditableControl = false;
            this.handleCheckOutCancel();
            this.createUneditableControl(toolkit);
        } else {
            this.isEditableControl = true;
            this.createEditableControl(toolkit);
        }
    }

    private void setValueInWidget(IWidgetAdapter.WidgetUpdateMode mode) {
        if (mode != IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE) {
            this.value = (IStreamResource)this.getWidgetAdapter().getValue(mode);
        }
        String label = null;
        if (this.value != null) {
            if (this.showName) {
                label = this.value.getName();
                if (this.showAuthorAndDate && this.checkedOutFile == null) {
                    if (this.value instanceof IStreamResourceWithMetaInformation) {
                        label = String.valueOf(label) + "\n(" + this.getAuthorAndDateText((IStreamResourceWithMetaInformation)this.value) + ")";
                    }
                } else if (this.checkedOutFile != null && this.checkedOutWatcher != null) {
                    label = String.valueOf(label) + "\n" + this.getTimeSinceLastSaveText();
                }
            } else {
                if (this.showAuthorAndDate) {
                    label = this.getAuthorAndDateText((IStreamResourceWithMetaInformation)this.value);
                } else {
                    assert (false);
                    label = "[no file information]";
                }
                if (this.checkedOutFile != null) {
                    label = String.valueOf(label) + "\n" + this.getTimeSinceLastSaveText();
                }
            }
        } else {
            label = this.isEditableControl ? "" : "-";
            if (this.showName && this.showAuthorAndDate) {
                label = String.valueOf(label) + "\n";
            }
        }
        this.text.setText(label);
        if (this.isEditableControl) {
            this.newLabelButton.setEnabled(true);
            if (this.value != null) {
                this.delLabelButton.setImage(CROSS);
                this.delLabelButton.setEnabled(true);
                if (this.isExternalEditingAllowed) {
                    this.checkInOutLabelButton.setEnabled(true);
                }
            } else {
                this.delLabelButton.setImage(NO_CROSS);
                this.delLabelButton.setEnabled(false);
                if (this.isExternalEditingAllowed) {
                    this.checkInOutLabelButton.setEnabled(false);
                }
            }
            if (this.isExternalEditingAllowed) {
                if (this.checkedOutFile != null) {
                    this.text.setBackground(this.checkOutColor);
                    this.checkInOutLabelButton.setImage(CHECK_IN);
                    this.checkInOutLabelButton.setToolTipText(Messages.getString("FileWidget.ButtonCheckIn.Tooltip"));
                    this.setCheckInOutMouseListener(false);
                    this.checkOutCancelLabelButton.setEnabled(true);
                    this.newLabelButton.setEnabled(false);
                    this.delLabelButton.setEnabled(false);
                } else {
                    this.text.setBackground(this.getFormToolkit().getColors().getBackground());
                    this.checkInOutLabelButton.setImage(CHECK_OUT);
                    this.checkInOutLabelButton.setToolTipText(Messages.getString("FileWidget.ButtonCheckOut.Tooltip"));
                    this.setCheckInOutMouseListener(true);
                    this.checkOutCancelLabelButton.setEnabled(false);
                }
            }
        }
    }

    private String getAuthorAndDateText(IStreamResourceWithMetaInformation valueAsSRWMI) {
        return String.valueOf(valueAsSRWMI.getCreator()) + " / " + valueAsSRWMI.getCreationDate(this.getCurrentPresentationContext());
    }

    private String getTimeSinceLastSaveText() {
        String content;
        if (this.checkedOutWatcher.getLastModifiedTime() > 0L) {
            if (!this.checkedOutWatcher.isChanged()) {
                content = Messages.getString("FileWidget.FileCurrentlyCheckedOutAndNotModified");
            } else {
                String minutes = String.valueOf(this.checkedOutWatcher.getLastModifiedDifferenceInMinutes());
                String time = DateFormat.getTimeInstance(2).format(new Long(this.checkedOutWatcher.getLastModifiedTime()));
                content = NLS.bind((String)Messages.getString("FileWidget.FileCurrentlyCheckedOutAndModified"), (Object)minutes, (Object)time);
            }
        } else {
            content = Messages.getString("FileWidget.FileCurrentlyCheckedOutWithoutStatus");
        }
        return "(" + content + ")";
    }

    private void createEditableControl(FormToolkit toolkit) {
        toolkit.setBorderStyle(2048);
        this.text = toolkit.createText(this.widgetComposite, "", 2);
        TableWrapData td = new TableWrapData(256);
        td.grabHorizontal = true;
        this.text.setLayoutData((Object)td);
        this.text.setEnabled(true);
        this.text.setEditable(false);
        this.text.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (FileWidget.this.value == null) {
                    FileWidget.this.handleFileDialog();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.newLabelButton = toolkit.createLabel(this.widgetComposite, null);
        this.newLabelButton.setImage(FOLDER);
        this.newLabelButton.setToolTipText(Messages.getString("FileWidget.ButtonChoose.Tooltip"));
        this.newLabelButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FileWidget.this.handleFileDialog();
            }
        });
        td = new TableWrapData();
        this.newLabelButton.setLayoutData((Object)td);
        this.delLabelButton = toolkit.createLabel(this.widgetComposite, null);
        this.delLabelButton.setImage(NO_CROSS);
        this.delLabelButton.setToolTipText(Messages.getString("FileWidget.ButtonDelete.Tooltip"));
        this.delLabelButton.setEnabled(false);
        this.delLabelButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FileWidget.this.handleDelete();
            }
        });
        td = new TableWrapData();
        this.delLabelButton.setLayoutData((Object)td);
        if (this.isExternalEditingAllowed) {
            this.checkInOutLabelButton = toolkit.createLabel(this.widgetComposite, null);
            this.checkInOutLabelButton.setEnabled(false);
            this.checkInOutLabelButton.setToolTipText(Messages.getString("FileWidget.ButtonCheckOut.Tooltip"));
            td = new TableWrapData();
            this.checkInOutLabelButton.setLayoutData((Object)td);
            this.checkOutCancelLabelButton = toolkit.createLabel(this.widgetComposite, null);
            this.checkOutCancelLabelButton.setImage(CHECK_OUT_CANCEL);
            this.checkOutCancelLabelButton.setToolTipText(Messages.getString("FileWidget.ButtonCheckOutCancel.Tooltip"));
            this.checkOutCancelLabelButton.setEnabled(false);
            this.checkOutCancelLabelButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    FileWidget.this.handleCheckOutCancel();
                }
            });
            td = new TableWrapData();
            this.checkOutCancelLabelButton.setLayoutData((Object)td);
        } else {
            toolkit.createLabel(this.widgetComposite, null).setLayoutData((Object)new TableWrapData());
            toolkit.createLabel(this.widgetComposite, null).setLayoutData((Object)new TableWrapData());
        }
        SimpleWidgetDropListener.addDropListenerToControl(this, 4, 8, (Control)this.text);
    }

    private void createUneditableControl(FormToolkit toolkit) {
        toolkit.setBorderStyle(0);
        this.text = toolkit.createText(this.widgetComposite, "-", 2);
        TableWrapData td = new TableWrapData(256);
        td.grabHorizontal = true;
        this.text.setLayoutData((Object)td);
        this.text.setEditable(false);
    }

    private void handleFileDialog() {
        FileChooserDialog dialog = new FileChooserDialog(new String[0], this.widgetComposite.getShell());
        File selectedFile = dialog.openForLoad();
        if (selectedFile != null && selectedFile.canRead()) {
            this.value = new FileResource(selectedFile);
            this.getWidgetAdapter().widgetModified();
            this.updateWidget_internal(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            this.lastCheckedOutFile = null;
        }
    }

    private void handleDelete() {
        if (this.value != null) {
            this.value = null;
            this.handleCheckOutCancel();
            this.getWidgetAdapter().widgetModified();
        }
    }

    private void handleCheckOut() {
        if (this.value != null) {
            try {
                Boolean newCheckOut = null;
                if (this.lastCheckedOutFile != null && this.lastCheckedOutFile.canRead()) {
                    MessageDialog dialog = new MessageDialog(this.widgetComposite.getShell(), Messages.getString("FileWidget.DialogOpenProjectOrLocal.Title"), this.widgetComposite.getDisplay().getSystemImage(4), Messages.getString("FileWidget.DialogOpenProjectOrLocal.Question"), 3, new String[]{Messages.getString("FileWidget.DialogOpenProjectOrLocal.OpenFromProject"), Messages.getString("FileWidget.DialogOpenProjectOrLocal.OpenLocal")}, 0);
                    int dialogAnswerCode = dialog.open();
                    if (dialogAnswerCode == 0) {
                        newCheckOut = Boolean.TRUE;
                    } else if (dialogAnswerCode == 1) {
                        newCheckOut = Boolean.FALSE;
                    }
                } else {
                    newCheckOut = Boolean.TRUE;
                }
                if (newCheckOut != null) {
                    if (newCheckOut.booleanValue()) {
                        File tempFile = new CheckOutTempFileProvider(this.value.getName()).createTemporaryDirectory().createTemporaryFile();
                        DataCopyHelper.copyFile((IStreamResource)this.value, (File)tempFile);
                        this.checkedOutFile = tempFile;
                    } else {
                        this.checkedOutFile = this.lastCheckedOutFile;
                    }
                    UrlLauncher.launchFile_noEx(this.checkedOutFile, this.getContainingWorkbenchPage());
                    this.getWidgetAdapter().setCloseVeto(new ITextProvider(){

                        public String getText(PresentationContext presentationContext) {
                            return Messages.getString("FileWidget.CloseVetoReason", presentationContext.getLocale());
                        }
                    });
                    this.startFileWatcher();
                    this.updateWidget(IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE);
                    this.lastCheckedOutFile = this.checkedOutFile;
                }
            }
            catch (JvmExternalResourceInteractionException e) {
                LOGGER.error("Error while checking out file", (Throwable)e);
                MessageDialog mDialog = new MessageDialog(this.widgetComposite.getShell(), Messages.getString("FileWidget.ErrorDuringCheckOut.Title"), null, Messages.getString("FileWidget.ErrorDuringCheckOut.Message"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
            }
        }
    }

    private void handleCheckIn() {
        if (this.checkedOutFile != null && this.checkedOutFile.exists()) {
            boolean doCheckIn = true;
            this.checkedOutWatcher.check();
            if (!this.checkedOutWatcher.isChanged()) {
                MessageDialog dialog = new MessageDialog(this.widgetComposite.getShell(), Messages.getString("FileWidget.NoChangesDetectedDialog.Title"), null, Messages.getString("FileWidget.NoChangesDetectedDialog.Message"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                boolean bl = doCheckIn = dialog.open() == 0;
            }
            if (doCheckIn) {
                this.value = new FileResourceWithOverwrittenName(this.checkedOutFile, this.value.getName());
                this.checkedOutFile = null;
                this.stopFileWatcher();
                this.getWidgetAdapter().unsetCloseVeto();
                this.getWidgetAdapter().widgetModified();
                this.updateWidget_internal(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
                this.getWidgetAdapter().removeWidgetAdapterError();
            }
        } else {
            this.getWidgetAdapter().setWidgetAdapterError(new ITextProvider(){

                public String getText(PresentationContext presentationContext) {
                    return Messages.getString("FileWidget.FileToCheckInIsMissing", presentationContext.getLocale());
                }
            });
        }
    }

    private void handleCheckOutCancel() {
        if (this.checkedOutFile != null) {
            this.stopFileWatcher();
            this.checkedOutFile = null;
            this.getWidgetAdapter().unsetCloseVeto();
            this.updateWidget(IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE);
            this.getWidgetAdapter().removeWidgetAdapterError();
        }
    }

    private void startFileWatcher() {
        assert (this.checkedOutWatcher == null) : "Cannot start new fileWatcher while old one is still running.";
        this.checkedOutWatcher = new FileWatcher(this.checkedOutFile);
        this.getWidgetAdapter().addScheduledTask((Runnable)this.checkedOutWatcher);
    }

    private void stopFileWatcher() {
        if (this.checkedOutWatcher != null) {
            this.getWidgetAdapter().removeScheduledTask((Runnable)this.checkedOutWatcher);
            this.checkedOutWatcher = null;
        }
    }

    private void setCheckInOutMouseListener(boolean checkout) {
        if (this.checkInOutLabelButton != null && !this.checkInOutLabelButton.isDisposed()) {
            if (this.checkInOutLabelButtonMouseListener != null) {
                this.checkInOutLabelButton.removeMouseListener(this.checkInOutLabelButtonMouseListener);
            }
            this.checkInOutLabelButtonMouseListener = checkout ? new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    FileWidget.this.handleCheckOut();
                }
            } : new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    FileWidget.this.handleCheckIn();
                }
            };
            this.checkInOutLabelButton.addMouseListener(this.checkInOutLabelButtonMouseListener);
        }
    }

    @Override
    public void refreshWidget_internal() {
        FormToolkit toolkit = this.getFormToolkit();
        if (this.widgetComposite != null) {
            Control[] children;
            Control[] controlArray = children = this.widgetComposite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.dispose();
                ++n2;
            }
            this.createControl_internal(toolkit);
            this.setValueInWidget(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            this.updateWidgetMessageDisplay();
            this.widgetComposite.getParent().pack();
        }
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        this.setValueInWidget(mode);
        this.updateWidgetMessageDisplay();
    }

    @Override
    protected void sendDisposeSignal_internal_DataWidget(boolean editorIsClosing) {
        if (!this.shallBeVisible() || editorIsClosing) {
            this.handleCheckOutCancel();
        }
    }

    public Object getCurrentValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.handleCheckOutCancel();
        this.value = (IStreamResource)value;
        this.getWidgetAdapter().widgetModified();
        this.updateWidget_internal(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
    }

    @Override
    public Transfer getTransferAgent() {
        return this.transferAgent;
    }

    @Override
    public Object getContentsFromTransferAgent(TransferData transferData) {
        return this.transferAgent.nativeToJava(transferData);
    }

    @Override
    public boolean hasCorrectObjectType(Object contents) {
        String[] array;
        return this.value == null && contents instanceof String[] && (array = (String[])contents).length == 1;
    }

    @Override
    public void performDrop(Object contents) {
        String[] array = (String[])contents;
        String path = array[0];
        File f = new File(path);
        this.value = new FileResource(f);
        this.getWidgetAdapter().widgetModified();
        this.updateWidget_internal(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
    }

    private class FileWatcher
    extends AbstractFileWatcher
    implements Runnable {
        public FileWatcher(File checkedOutFile) {
            super(checkedOutFile);
        }

        @Override
        public void run() {
            this.check();
        }

        protected void update() {
            if (FileWidget.this.widgetComposite != null && !FileWidget.this.widgetComposite.isDisposed()) {
                FileWidget.this.widgetComposite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FileWidget.this.widgetComposite != null && !FileWidget.this.widgetComposite.isDisposed()) {
                            FileWidget.this.updateWidget(IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE);
                        }
                    }
                });
            }
        }
    }
}

