/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.widgets.browser;

import com.arcway.lib.eclipse.gui.widgets.browser.IBrowser;
import com.arcway.lib.eclipse.gui.widgets.browser.html2text.HTML2TextReader;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.w3c.tidy.Node;
import org.w3c.tidy.Tidy;

public class BrowserSubstitute
implements IBrowser {
    private static final ILogger LOGGER = Logger.getLogger(BrowserSubstitute.class);
    private static final String UTF_8 = "UTF-8";
    private final StyledText styledText;

    public BrowserSubstitute(Composite parent, int style) {
        this.styledText = new StyledText(parent, style);
        this.styledText.setEditable(false);
    }

    public Composite getSWTControl() {
        return this.styledText;
    }

    @Override
    public void setHtml(String html) {
        String text;
        TextPresentation presentation;
        try {
            String tidyHtml = BrowserSubstitute.convert2Xhtml(html);
            presentation = new TextPresentation();
            try {
                HTML2TextReader reader = new HTML2TextReader(new StringReader(tidyHtml), presentation);
                text = reader.getString();
            }
            catch (IOException e) {
                text = tidyHtml;
                presentation = null;
            }
        }
        catch (Exception e1) {
            LOGGER.debug("Problem while rendering HTML - HTML source will be displayed ", (Throwable)e1);
            text = html;
            presentation = null;
        }
        this.styledText.setText(text);
        if (presentation != null) {
            TextPresentation.applyTextPresentation((TextPresentation)presentation, (StyledText)this.styledText);
        }
    }

    private static String convert2Xhtml(String rawHtml) throws Exception {
        Tidy tidy = new Tidy();
        tidy.setCharEncoding(3);
        tidy.setXHTML(true);
        tidy.setIndentContent(true);
        ByteArrayInputStream htmlInputStream = new ByteArrayInputStream(rawHtml.getBytes(UTF_8));
        ByteArrayOutputStream xhtmlXmlOutputStream = new ByteArrayOutputStream();
        Node htmlDocument = tidy.parse((InputStream)htmlInputStream, (OutputStream)xhtmlXmlOutputStream);
        if (htmlDocument != null && xhtmlXmlOutputStream.size() > 0) {
            return xhtmlXmlOutputStream.toString(UTF_8);
        }
        throw new Exception("Parsing of HTML Document failed.");
    }
}

