/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ImageButton
extends Canvas
implements MouseMoveListener {
    private Cursor handCursor;
    private final Image image;
    private boolean enabled = true;

    public ImageButton(Composite parent, String text, Image image, int style) {
        super(parent, style);
        assert (image != null);
        this.image = image;
        this.setToolTipText(text);
        this.setLayout((Layout)new FillLayout());
        this.addMouseMoveListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageButton.this.dispose();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ImageButton.this.paintControl(e);
            }
        });
    }

    void paintControl(PaintEvent e) {
        GC gc = e.gc;
        if (this.image != null) {
            if (this.enabled) {
                gc.drawImage(this.image, 0, 0);
            } else {
                Image grayedImage = new Image((Device)this.getDisplay(), this.image, 2);
                gc.drawImage(grayedImage, 0, 0);
                grayedImage.dispose();
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.handCursor != null && !this.handCursor.isDisposed()) {
            this.handCursor.dispose();
        }
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Rectangle imageBounds = this.image.getBounds();
        return new Point(imageBounds.width, imageBounds.height);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.redraw();
    }

    public void mouseMove(MouseEvent e) {
        Control source = (Control)e.getSource();
        if (this.enabled) {
            if (this.handCursor == null || this.handCursor.isDisposed()) {
                this.handCursor = new Cursor((Device)this.getDisplay(), 21);
            }
            source.setCursor(this.handCursor);
        }
    }
}

