/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.viewers;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ArcwayTable
extends Table {
    private final Table realTable;
    private final int fixedCols;

    public ArcwayTable(SashForm parent, int style, int fixedCols) {
        super((Composite)parent, style);
        this.fixedCols = fixedCols;
        this.realTable = new Table((Composite)parent, style);
        this.realTable.setLayoutData((Object)new GridData(1808));
    }

    public void addSelectionListener(SelectionListener listener) {
        super.addSelectionListener(listener);
        this.realTable.addSelectionListener(listener);
    }

    public void clear(int start, int end) {
        super.clear(start, end);
        this.realTable.clear(start, end);
    }

    public void clear(int index) {
        super.clear(index);
        this.realTable.clear(index);
    }

    public void clear(int[] indices) {
        super.clear(indices);
        this.realTable.clear(indices);
    }

    public void clearAll() {
        super.clearAll();
        this.realTable.clearAll();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point fixed = super.computeSize(wHint, hHint, changed);
        Point real = this.realTable.computeSize(wHint, hHint, changed);
        fixed.x += real.x;
        return fixed;
    }

    public void deselect(int index) {
        super.deselect(index);
        this.realTable.deselect(index);
    }

    public void deselect(int[] indices) {
        super.deselect(indices);
        this.realTable.deselect(indices);
    }

    public void deselectAll() {
        super.deselectAll();
        this.realTable.deselectAll();
    }

    public TableColumn getColumn(int index) {
        if (index > this.fixedCols) {
            return this.realTable.getColumn(index - this.fixedCols);
        }
        return super.getColumn(index);
    }

    public int getColumnCount() {
        return super.getColumnCount() + this.realTable.getColumnCount();
    }

    public int[] getColumnOrder() {
        int[] fixed = super.getColumnOrder();
        int[] real = this.realTable.getColumnOrder();
        int[] together = new int[fixed.length + real.length];
        int i = 0;
        while (i < together.length) {
            together[i] = i < this.fixedCols ? fixed[i] : real[i - this.fixedCols];
            ++i;
        }
        return together;
    }

    public TableColumn[] getColumns() {
        TableColumn[] fixed = super.getColumns();
        TableColumn[] real = this.realTable.getColumns();
        TableColumn[] together = new TableColumn[fixed.length + real.length];
        System.arraycopy(fixed, 0, together, 0, fixed.length);
        System.arraycopy(real, 0, together, fixed.length + 1, real.length);
        return together;
    }

    public TableItem getItem(int index) {
        if (index < this.fixedCols) {
            return super.getItem(index);
        }
        return this.realTable.getItem(index - this.fixedCols);
    }
}

